/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.util.VisibleForTesting;

abstract class AbstractLinearProbeLongHashSet
extends AbstractLongIterable
implements LongSet {
    private static final long EMPTY = 0L;
    static final long REMOVED = 1L;
    Memory memory;
    int capacity;
    int elementsInMemory;
    long modCount;
    boolean hasZero;
    boolean hasOne;

    AbstractLinearProbeLongHashSet() {
    }

    AbstractLinearProbeLongHashSet(AbstractLinearProbeLongHashSet src) {
        this.memory = src.memory;
        this.capacity = src.capacity;
        this.hasZero = src.hasZero;
        this.hasOne = src.hasOne;
        this.elementsInMemory = src.elementsInMemory;
    }

    @Override
    public LongIterator longIterator() {
        return new FailFastIterator();
    }

    @Override
    public long[] toArray() {
        MutableInt idx = new MutableInt();
        long[] array = new long[this.size()];
        this.each(element -> {
            array[idx.getAndIncrement()] = element;
        });
        return array;
    }

    @Override
    public boolean contains(long element) {
        if (element == 0L) {
            return this.hasZero;
        }
        if (element == 1L) {
            return this.hasOne;
        }
        int idx = this.indexOf(element);
        return this.valueAt(idx) == element;
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        if (this.hasZero) {
            procedure.accept(0L);
        }
        if (this.hasOne) {
            procedure.accept(1L);
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value2 = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value2)) continue;
            procedure.accept(value2);
            ++visited;
        }
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        if (this.hasZero && predicate.test(0L) || this.hasOne && predicate.test(1L)) {
            return true;
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value2 = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value2)) continue;
            if (predicate.test(value2)) {
                return true;
            }
            ++visited;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        if (this.hasZero && !predicate.test(0L) || this.hasOne && !predicate.test(1L)) {
            return false;
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value2 = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value2)) continue;
            if (!predicate.test(value2)) {
                return false;
            }
            ++visited;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int count(LongPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long sum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long max() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long min() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MutableLongSet select(LongPredicate predicate) {
        return this.select(predicate, new LongHashSet());
    }

    @Override
    public MutableLongSet reject(LongPredicate predicate) {
        return this.reject(predicate, new LongHashSet());
    }

    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        UnifiedSet result2 = new UnifiedSet(this.size());
        this.each(element -> result2.add(function.apply(element)));
        return result2;
    }

    @Override
    public int hashCode() {
        MutableInt h = new MutableInt();
        this.each(element -> h.add((int)(element ^ element >>> 32)));
        return h.intValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet other2 = (LongSet)obj;
        return this.size() == other2.size() && this.containsAll(other2);
    }

    @Override
    public int size() {
        return this.elementsInMemory + (this.hasZero ? 1 : 0) + (this.hasOne ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("offheap,size=").append(String.valueOf(this.size())).append("; ");
            LongIterator iterator2 = this.longIterator();
            for (int i = 0; i < 100 && iterator2.hasNext(); ++i) {
                appendable.append(Long.toString(iterator2.next()));
                if (!iterator2.hasNext()) continue;
                appendable.append(", ");
            }
            if (iterator2.hasNext()) {
                appendable.append("...");
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isRealValue(long value2) {
        return value2 != 1L && value2 != 0L;
    }

    @VisibleForTesting
    int hashAndMask(long element) {
        long h = SpreadFunctions.longSpreadOne(element);
        return Long.hashCode(h) & this.capacity - 1;
    }

    long valueAt(int idx) {
        return this.memory.readLong((long)idx * 8L);
    }

    int indexOf(long element) {
        int idx = this.hashAndMask(element);
        int firstRemovedIdx = -1;
        for (int i = 0; i < this.capacity; ++i) {
            long valueAtIdx = this.valueAt(idx);
            if (valueAtIdx == element) {
                return idx;
            }
            if (valueAtIdx == 0L) {
                return firstRemovedIdx == -1 ? idx : firstRemovedIdx;
            }
            if (valueAtIdx == 1L && firstRemovedIdx == -1) {
                firstRemovedIdx = idx;
            }
            idx = idx + 1 & this.capacity - 1;
        }
        throw new AssertionError((Object)("Failed to determine index for " + element));
    }

    class FailFastIterator
    implements MutableLongIterator {
        private final long modCount;
        private int visited;
        private int idx;
        private boolean handledZero;
        private boolean handledOne;

        FailFastIterator() {
            this.modCount = AbstractLinearProbeLongHashSet.this.modCount;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long next() {
            long value2;
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator is exhausted");
            }
            ++this.visited;
            if (!this.handledZero) {
                this.handledZero = true;
                if (AbstractLinearProbeLongHashSet.this.hasZero) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (AbstractLinearProbeLongHashSet.this.hasOne) {
                    return 1L;
                }
            }
            while (!AbstractLinearProbeLongHashSet.isRealValue(value2 = AbstractLinearProbeLongHashSet.this.valueAt(this.idx++))) {
            }
            return value2;
        }

        @Override
        public boolean hasNext() {
            this.checkState();
            return this.visited < AbstractLinearProbeLongHashSet.this.size();
        }

        private void checkState() {
            if (this.modCount != AbstractLinearProbeLongHashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

