/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;

public class OffHeapMemoryAllocator
implements MemoryAllocator {
    private final MemoryAllocationTracker tracker;
    private final OffHeapBlockAllocator blockAllocator;

    public OffHeapMemoryAllocator(MemoryAllocationTracker tracker, OffHeapBlockAllocator blockAllocator) {
        this.tracker = Objects.requireNonNull(tracker);
        this.blockAllocator = Objects.requireNonNull(blockAllocator);
    }

    @Override
    public Memory allocate(long size2, boolean zeroed) {
        OffHeapBlockAllocator.MemoryBlock block = this.blockAllocator.allocate(size2, this.tracker);
        if (zeroed) {
            UnsafeUtil.setMemory(block.unalignedAddr, block.unalignedSize, (byte)0);
        }
        return new OffHeapMemory(block);
    }

    class OffHeapMemory
    implements Memory {
        final OffHeapBlockAllocator.MemoryBlock block;

        OffHeapMemory(OffHeapBlockAllocator.MemoryBlock block) {
            this.block = block;
        }

        @Override
        public long readLong(long offset) {
            return UnsafeUtil.getLong(this.block.addr + offset);
        }

        @Override
        public void writeLong(long offset, long value2) {
            UnsafeUtil.putLong(this.block.addr + offset, value2);
        }

        @Override
        public void clear() {
            UnsafeUtil.setMemory(this.block.unalignedAddr, this.block.unalignedSize, (byte)0);
        }

        @Override
        public long size() {
            return this.block.size;
        }

        @Override
        public void free() {
            OffHeapMemoryAllocator.this.blockAllocator.free(this.block, OffHeapMemoryAllocator.this.tracker);
        }

        @Override
        public Memory copy() {
            OffHeapBlockAllocator.MemoryBlock copy2 = OffHeapMemoryAllocator.this.blockAllocator.allocate(this.block.size, OffHeapMemoryAllocator.this.tracker);
            UnsafeUtil.copyMemory(this.block.addr, copy2.addr, this.block.size);
            return new OffHeapMemory(copy2);
        }

        @Override
        public ByteBuffer asByteBuffer() {
            Preconditions.checkState(this.block.size <= Integer.MAX_VALUE, "Can't create ByteBuffer: memory size exceeds integer limit");
            try {
                return UnsafeUtil.newDirectByteBuffer(this.block.addr, Math.toIntExact(this.block.size));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

