/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSets;

public class MutableDiffSetsImpl<T>
implements MutableDiffSets<T> {
    private Set<T> addedElements;
    private Set<T> removedElements;
    private Predicate<T> filter;

    private MutableDiffSetsImpl(Set<T> addedElements, Set<T> removedElements) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
    }

    public MutableDiffSetsImpl() {
        this(null, null);
    }

    @Override
    public boolean add(T elem2) {
        boolean wasRemoved = this.removed(false).remove(elem2);
        return wasRemoved || this.added(true).add(elem2);
    }

    @Override
    public void addAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.add(elems.next());
        }
    }

    @Override
    public boolean remove(T elem2) {
        boolean removedFromAddedElements = this.added(false).remove(elem2);
        return removedFromAddedElements || this.removed(true).add(elem2);
    }

    @Override
    public void removeAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.remove(elems.next());
        }
    }

    @Override
    public void clear() {
        if (this.addedElements != null) {
            this.addedElements.clear();
        }
        if (this.removedElements != null) {
            this.removedElements.clear();
        }
    }

    @Override
    public boolean unRemove(T item) {
        return this.removed(false).remove(item);
    }

    protected Set<T> added(boolean create2) {
        if (this.addedElements == null) {
            if (!create2) {
                return Collections.emptySet();
            }
            this.addedElements = new HashSet<T>();
        }
        return this.addedElements;
    }

    private void ensureFilterHasBeenCreated() {
        if (this.filter == null) {
            this.filter = item -> !this.removed(false).contains(item) && !this.added(false).contains(item);
        }
    }

    public String toString() {
        return String.format("{+%s, -%s}", this.added(false), this.removed(false));
    }

    @Override
    public boolean isAdded(T elem2) {
        return this.added(false).contains(elem2);
    }

    @Override
    public boolean isRemoved(T elem2) {
        return this.removed(false).contains(elem2);
    }

    @Override
    public Set<T> getAdded() {
        return this.resultSet(this.addedElements);
    }

    @Override
    public Set<T> getRemoved() {
        return this.resultSet(this.removedElements);
    }

    @Override
    public boolean isEmpty() {
        return this.added(false).isEmpty() && this.removed(false).isEmpty();
    }

    @Override
    public Iterator<T> apply(Iterator<? extends T> source) {
        Iterator<Object> result2 = source;
        if (this.removedElements != null && !this.removedElements.isEmpty() || this.addedElements != null && !this.addedElements.isEmpty()) {
            this.ensureFilterHasBeenCreated();
            result2 = Iterators.filter(this.filter, result2);
        }
        if (this.addedElements != null && !this.addedElements.isEmpty()) {
            result2 = Iterators.concat(result2, this.addedElements.iterator());
        }
        return result2;
    }

    @Override
    public int delta() {
        return this.added(false).size() - this.removed(false).size();
    }

    @Override
    public MutableDiffSetsImpl<T> filterAdded(Predicate<T> addedFilter) {
        return new MutableDiffSetsImpl<T>(Iterables.asSet(Iterables.filter(addedFilter, this.added(false))), Iterables.asSet(this.removed(false)));
    }

    protected Set<T> removed(boolean create2) {
        if (this.removedElements == null) {
            if (!create2) {
                return Collections.emptySet();
            }
            this.removedElements = new HashSet<T>();
        }
        return this.removedElements;
    }

    public void replace(T toRemove, T toAdd) {
        Set<T> added = this.added(true);
        boolean removedFromAdded = added.remove(toRemove);
        this.removed(false).remove(toAdd);
        added.add(toAdd);
        if (!removedFromAdded) {
            this.removed(true).add(toRemove);
        }
    }

    private Set<T> resultSet(Set<T> coll) {
        return coll == null ? Collections.emptySet() : Collections.unmodifiableSet(coll);
    }
}

