/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.util.concurrent.ThreadFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public class DefaultFileSystemWatcherService
implements FileSystemWatcherService {
    private final JobScheduler jobScheduler;
    private final FileWatcher fileWatcher;
    private final FileSystemEventWatcher eventWatcher;
    private ThreadFactory fileWatchers;
    private Thread watcher;

    public DefaultFileSystemWatcherService(JobScheduler jobScheduler, FileWatcher fileWatcher) {
        this.jobScheduler = jobScheduler;
        this.fileWatcher = fileWatcher;
        this.eventWatcher = new FileSystemEventWatcher();
    }

    @Override
    public void init() {
        this.fileWatchers = this.jobScheduler.threadFactory(Group.FILE_WATCHER);
    }

    @Override
    public synchronized void start() {
        assert (this.watcher == null);
        this.watcher = this.fileWatchers.newThread(this.eventWatcher);
        this.watcher.start();
    }

    @Override
    public synchronized void stop() throws Throwable {
        this.eventWatcher.stopWatching();
        if (this.watcher != null) {
            this.watcher.interrupt();
            this.watcher.join();
            this.watcher = null;
        }
    }

    @Override
    public void shutdown() throws Throwable {
        this.fileWatcher.close();
    }

    @Override
    public FileWatcher getFileWatcher() {
        return this.fileWatcher;
    }

    private class FileSystemEventWatcher
    implements Runnable {
        private FileSystemEventWatcher() {
        }

        @Override
        public void run() {
            try {
                DefaultFileSystemWatcherService.this.fileWatcher.startWatching();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void stopWatching() {
            DefaultFileSystemWatcherService.this.fileWatcher.stopWatching();
        }
    }
}

