/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;

    public DefaultRecoveryService(StorageEngine storageEngine, LogTailScanner logTailScanner, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, RecoveryStartInformationProvider.Monitor monitor) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logTailScanner, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public void startRecovery() {
        this.storageEngine.prepareForRecoveryRequired();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode) throws Exception {
        return new RecoveryVisitor(this.storageEngine, mode);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position2) throws IOException {
        return this.logicalTransactionStore.getTransactions(position2);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition position2) throws IOException {
        return this.logicalTransactionStore.getTransactionsInReverseOrder(position2);
    }

    @Override
    public void transactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition positionAfterLastRecoveredTransaction) {
        long recoveredTransactionLogVersion = positionAfterLastRecoveredTransaction.getLogVersion();
        long recoveredTransactionOffset = positionAfterLastRecoveredTransaction.getByteOffset();
        if (lastRecoveredTransaction != null) {
            LogEntryCommit commitEntry = lastRecoveredTransaction.getCommitEntry();
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(commitEntry.getTxId(), LogEntryStart.checksum(lastRecoveredTransaction.getStartEntry()), commitEntry.getTimeWritten(), recoveredTransactionOffset, recoveredTransactionLogVersion);
        }
        this.logVersionRepository.setCurrentLogVersion(recoveredTransactionLogVersion);
    }

    static class RecoveryVisitor
    implements RecoveryApplier {
        private final StorageEngine storageEngine;
        private final TransactionApplicationMode mode;

        RecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode) {
            this.storageEngine = storageEngine;
            this.mode = mode;
        }

        @Override
        public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            TransactionToApply tx = new TransactionToApply(txRepresentation, txId);
            tx.commitment(Commitment.NO_COMMITMENT, txId);
            tx.logPosition(transaction.getStartEntry().getStartPosition());
            this.storageEngine.apply(tx, this.mode);
            return false;
        }

        @Override
        public void close() {
        }
    }
}

