/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.InputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jline.console.ConsoleReader;
import org.neo4j.driver.v1.exceptions.AuthenticationException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiLogger;
import org.neo4j.shell.prettyprint.PrettyConfig;

public class Main {
    static final String NEO_CLIENT_ERROR_SECURITY_UNAUTHORIZED = "Neo.ClientError.Security.Unauthorized";
    private final InputStream in;
    private final PrintStream out;

    public static void main(String[] args) {
        CliArgs cliArgs = CliArgHelper.parse(args);
        if (cliArgs == null) {
            System.exit(1);
        }
        Main main2 = new Main();
        main2.startShell(cliArgs);
    }

    Main() {
        this(System.in, System.out);
    }

    Main(InputStream in2, PrintStream out) {
        this.in = in2;
        this.out = out;
    }

    void startShell(@Nonnull CliArgs cliArgs) {
        if (cliArgs.getVersion()) {
            this.out.println("Cypher-Shell " + Build.version());
        }
        if (cliArgs.getDriverVersion()) {
            this.out.println("Neo4j Driver " + Build.driverVersion());
        }
        if (cliArgs.getVersion() || cliArgs.getDriverVersion()) {
            return;
        }
        AnsiLogger logger = new AnsiLogger(cliArgs.getDebugMode());
        PrettyConfig prettyConfig = new PrettyConfig(cliArgs);
        ConnectionConfig connectionConfig = new ConnectionConfig(cliArgs.getScheme(), cliArgs.getHost(), cliArgs.getPort(), cliArgs.getUsername(), cliArgs.getPassword(), cliArgs.getEncryption());
        try {
            CypherShell shell = new CypherShell(logger, prettyConfig);
            this.connectMaybeInteractively(shell, connectionConfig, ShellRunner.isInputInteractive());
            ShellRunner shellRunner = ShellRunner.getShellRunner(cliArgs, shell, logger, connectionConfig);
            CommandHelper commandHelper = new CommandHelper(logger, shellRunner.getHistorian(), shell);
            shell.setCommandHelper(commandHelper);
            int code = shellRunner.runUntilEnd();
            System.exit(code);
        }
        catch (Throwable e) {
            logger.printError(e);
            System.exit(1);
        }
    }

    void connectMaybeInteractively(@Nonnull CypherShell shell, @Nonnull ConnectionConfig connectionConfig, boolean interactively) throws Exception {
        try {
            shell.connect(connectionConfig);
        }
        catch (AuthenticationException e) {
            if (!connectionConfig.username().isEmpty() && !connectionConfig.password().isEmpty()) {
                throw e;
            }
            if (interactively) {
                if (connectionConfig.username().isEmpty()) {
                    connectionConfig.setUsername(this.promptForNonEmptyText("username", null));
                }
                if (connectionConfig.password().isEmpty()) {
                    connectionConfig.setPassword(this.promptForText("password", Character.valueOf('*')));
                }
                shell.connect(connectionConfig);
            }
            throw e;
        }
    }

    @Nonnull
    private String promptForNonEmptyText(@Nonnull String prompt, @Nullable Character mask) throws Exception {
        String text = this.promptForText(prompt, mask);
        if (!text.isEmpty()) {
            return text;
        }
        this.out.println(prompt + " cannot be empty");
        this.out.println();
        return this.promptForNonEmptyText(prompt, mask);
    }

    @Nonnull
    private String promptForText(@Nonnull String prompt, @Nullable Character mask) throws Exception {
        ConsoleReader consoleReader = new ConsoleReader(this.in, this.out);
        consoleReader.setExpandEvents(false);
        consoleReader.setHandleUserInterrupt(false);
        String line = consoleReader.readLine(prompt + ": ", mask);
        consoleReader.close();
        if (line == null) {
            throw new CommandException("No text could be read, exiting...");
        }
        return line;
    }
}

