/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.MemoryHistory;
import org.neo4j.shell.Historian;
import org.neo4j.shell.log.Logger;

public class FileHistorian
implements Historian {
    private final MemoryHistory history;

    private FileHistorian(MemoryHistory history) {
        this.history = history;
    }

    @Nonnull
    public static Historian setupHistory(@Nonnull ConsoleReader reader, @Nonnull Logger logger, @Nonnull File historyFile) throws IOException {
        try {
            File dir = historyFile.getParentFile();
            if (!dir.isDirectory() && !dir.mkdir()) {
                throw new IOException("Failed to create directory for history: " + dir.getAbsolutePath());
            }
            FileHistory history = new FileHistory(historyFile);
            reader.setHistory(history);
            FileHistorian.addShutdownHookToFlushHistory(logger, history);
            return new FileHistorian(history);
        }
        catch (IOException e) {
            logger.printError("Could not load history file. Falling back to session-based history.\n" + e.getMessage());
            MemoryHistory history = new MemoryHistory();
            reader.setHistory(history);
            return new FileHistorian(history);
        }
    }

    private static void addShutdownHookToFlushHistory(final @Nonnull Logger logger, final FileHistory history) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    history.flush();
                }
                catch (IOException e) {
                    logger.printError("Failed to save history:\n" + e.getMessage());
                }
            }
        });
    }

    @Nonnull
    public static File getDefaultHistoryFile() {
        File dir = new File(System.getProperty("user.home"), ".neo4j");
        return new File(dir, ".neo4j_history");
    }

    @Override
    @Nonnull
    public List<String> getHistory() {
        ArrayList<String> result2 = new ArrayList<String>();
        this.history.forEach(entry -> result2.add(String.valueOf(entry.value())));
        return result2;
    }

    @Override
    public void flushHistory() throws IOException {
        if (this.history instanceof FileHistory) {
            ((FileHistory)this.history).flush();
        }
    }
}

