/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import jline.console.ConsoleReader;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.cli.FileHistorian;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class InteractiveShellRunner
implements ShellRunner,
SignalHandler {
    static final String INTERRUPT_SIGNAL = "INT";
    private static final AnsiFormattedText freshPrompt = AnsiFormattedText.s().bold().append("neo4j> ");
    private static final AnsiFormattedText continuationPrompt = AnsiFormattedText.s().bold().append("       ");
    private static final AnsiFormattedText transactionPrompt = AnsiFormattedText.s().bold().append("neo4j# ");
    private final AtomicBoolean currentlyExecuting;
    private final Logger logger;
    private final ConsoleReader reader;
    private final Historian historian;
    private final StatementParser statementParser;
    private final TransactionHandler txHandler;
    private final StatementExecuter executer;
    private final UserMessagesHandler userMessagesHandler;

    public InteractiveShellRunner(@Nonnull StatementExecuter executer, @Nonnull TransactionHandler txHandler, @Nonnull Logger logger, @Nonnull StatementParser statementParser, @Nonnull InputStream inputStream, @Nonnull File historyFile, @Nonnull UserMessagesHandler userMessagesHandler) throws IOException {
        this.userMessagesHandler = userMessagesHandler;
        this.currentlyExecuting = new AtomicBoolean(false);
        this.executer = executer;
        this.txHandler = txHandler;
        this.logger = logger;
        this.statementParser = statementParser;
        this.reader = this.setupConsoleReader(logger, inputStream);
        this.historian = FileHistorian.setupHistory(this.reader, logger, historyFile);
        Signal.handle(new Signal(INTERRUPT_SIGNAL), this);
    }

    private ConsoleReader setupConsoleReader(@Nonnull Logger logger, @Nonnull InputStream inputStream) throws IOException {
        ConsoleReader reader = new ConsoleReader(inputStream, logger.getOutputStream());
        reader.setExpandEvents(false);
        reader.setHandleUserInterrupt(false);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runUntilEnd() {
        int exitCode = 0;
        boolean running = true;
        this.logger.printIfVerbose(this.userMessagesHandler.getWelcomeMessage());
        while (running) {
            try {
                for (String statement2 : this.readUntilStatement()) {
                    this.currentlyExecuting.set(true);
                    this.executer.execute(statement2);
                    this.currentlyExecuting.set(false);
                }
            }
            catch (ExitException e) {
                exitCode = e.getCode();
                running = false;
            }
            catch (NoMoreInputException e) {
                running = false;
            }
            catch (Throwable e) {
                this.logger.printError(e);
            }
            finally {
                this.currentlyExecuting.set(false);
            }
        }
        this.logger.printIfVerbose(this.userMessagesHandler.getExitMessage());
        return exitCode;
    }

    @Override
    @Nonnull
    public Historian getHistorian() {
        return this.historian;
    }

    @Nonnull
    public List<String> readUntilStatement() throws IOException, NoMoreInputException {
        while (true) {
            String line;
            if ((line = this.reader.readLine(this.getPrompt().renderedString())) == null) {
                throw new NoMoreInputException();
            }
            if (line.trim().isEmpty() && !this.statementParser.containsText()) continue;
            this.statementParser.parseMoreText(line + "\n");
            if (this.statementParser.hasStatements()) break;
        }
        return this.statementParser.consumeStatements();
    }

    AnsiFormattedText getPrompt() {
        if (this.statementParser.containsText()) {
            return continuationPrompt;
        }
        if (this.txHandler.isTransactionOpen()) {
            return transactionPrompt;
        }
        return freshPrompt;
    }

    @Override
    public void handle(Signal signal) {
        if (this.currentlyExecuting.get()) {
            this.executer.reset();
        } else {
            this.logger.printError(AnsiFormattedText.s().colorRed().append("\nInterrupted (Note that Cypher queries must end with a ").bold().append("semicolon. ").boldOff().append("Type ").bold().append(":exit").append(" ").boldOff().append("to exit the shell.)").formattedString());
            this.resetPrompt();
        }
    }

    private void resetPrompt() {
        try {
            boolean more = true;
            while (more) {
                more = this.reader.delete();
            }
            more = true;
            while (more) {
                more = this.reader.backspace();
            }
            this.statementParser.reset();
            this.reader.setPrompt(this.getPrompt().renderedString());
            this.reader.redrawLine();
            this.reader.flush();
        }
        catch (IOException e) {
            this.logger.printError(e);
        }
    }
}

