/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fusesource.jansi.Ansi;

public class AnsiFormattedText {
    private static final String RED = "RED";
    private static final String BOLD = "BOLD";
    private static final String DEFAULT_COLOR = "DEFAULT";
    private final Map<String, Boolean> attributes = new HashMap<String, Boolean>();
    private final LinkedList<AnsiFormattedString> pieces = new LinkedList();
    private String color = null;

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> primary, Map<K, V> secondary) {
        HashMap<K, V> result2 = new HashMap<K, V>();
        result2.putAll(primary);
        secondary.forEach(result2::putIfAbsent);
        return result2;
    }

    public static AnsiFormattedText s() {
        return new AnsiFormattedText();
    }

    public static AnsiFormattedText from(@Nullable String string2) {
        AnsiFormattedText st = new AnsiFormattedText();
        if (string2 != null) {
            st.append(string2);
        }
        return st;
    }

    @Nonnull
    public String formattedString() {
        StringBuilder sb = new StringBuilder();
        for (AnsiFormattedString s2 : this.pieces) {
            ArrayList<String> codes = new ArrayList<String>();
            if (s2.color != null && !DEFAULT_COLOR.equals(s2.color)) {
                codes.add(s2.color);
            }
            if (s2.attributes.getOrDefault(BOLD, false).booleanValue()) {
                codes.add(BOLD);
            }
            if (!codes.isEmpty()) {
                sb.append("@|").append(String.join((CharSequence)",", codes)).append(" ");
            }
            sb.append(s2.string);
            if (codes.isEmpty()) continue;
            sb.append("|@");
        }
        return sb.toString();
    }

    @Nonnull
    public String renderedString() {
        return Ansi.ansi().render(this.formattedString()).toString();
    }

    @Nonnull
    public String plainString() {
        StringBuilder sb = new StringBuilder();
        this.pieces.forEach(sb::append);
        return sb.toString();
    }

    public AnsiFormattedText append(AnsiFormattedText existing) {
        existing.pieces.forEach(s2 -> this.pieces.add(new AnsiFormattedString(this.color != null ? this.color : s2.color, AnsiFormattedText.mergeMaps(this.attributes, s2.attributes), s2.string)));
        return this;
    }

    public AnsiFormattedText append(String s2) {
        this.pieces.add(new AnsiFormattedString(this.color, this.attributes, s2));
        return this;
    }

    public AnsiFormattedText bold() {
        this.attributes.put(BOLD, true);
        return this;
    }

    public AnsiFormattedText boldOff() {
        this.attributes.put(BOLD, false);
        return this;
    }

    public AnsiFormattedText colorRed() {
        this.color = RED;
        return this;
    }

    public AnsiFormattedText colorDefault() {
        this.color = DEFAULT_COLOR;
        return this;
    }

    private static class AnsiFormattedString {
        final String color;
        final Map<String, Boolean> attributes = new HashMap<String, Boolean>();
        final String string;

        AnsiFormattedString(String color, Map<String, Boolean> attributes, String s2) {
            this.color = color;
            this.attributes.putAll(attributes);
            this.string = s2;
        }

        public String toString() {
            return this.string;
        }
    }
}

