/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.prettyprint.TablePlanFormatter;
import org.neo4j.shell.state.BoltResult;

public class TableOutputFormatter
implements OutputFormatter {
    private final boolean wrap;
    private final int numSampleRows;

    public TableOutputFormatter(boolean wrap, int numSampleRows) {
        this.wrap = wrap;
        this.numSampleRows = numSampleRows;
    }

    @Override
    public int formatAndCount(@Nonnull BoltResult result2, @Nonnull LinePrinter output) {
        String[] columns = result2.getKeys().toArray(new String[0]);
        if (columns.length == 0) {
            return 0;
        }
        Iterator<Record> records = result2.iterate();
        return this.formatResultAndCountRows(columns, records, output);
    }

    private List<Record> take(Iterator<Record> records, int count2) {
        ArrayList<Record> topRecords = new ArrayList<Record>(count2);
        while (records.hasNext() && topRecords.size() < count2) {
            topRecords.add(records.next());
        }
        return topRecords;
    }

    private int formatResultAndCountRows(String[] columns, Iterator<Record> records, LinePrinter output) {
        List<Record> topRecords = this.take(records, this.numSampleRows);
        int[] columnSizes = this.calculateColumnSizes(columns, topRecords);
        int totalWidth = 1;
        for (int columnSize : columnSizes) {
            totalWidth += columnSize + 3;
        }
        StringBuilder builder = new StringBuilder(totalWidth);
        String headerLine = this.formatRow(builder, columnSizes, columns);
        int lineWidth = totalWidth - 2;
        String dashes2 = "+" + OutputFormatter.repeat('-', lineWidth) + "+";
        output.printOut(dashes2);
        output.printOut(headerLine);
        output.printOut(dashes2);
        int numberOfRows = 0;
        for (Record record : topRecords) {
            output.printOut(this.formatRecord(builder, columnSizes, record));
            ++numberOfRows;
        }
        while (records.hasNext()) {
            output.printOut(this.formatRecord(builder, columnSizes, records.next()));
            ++numberOfRows;
        }
        output.printOut(String.format("%s%n", dashes2));
        return numberOfRows;
    }

    private int[] calculateColumnSizes(@Nonnull String[] columns, @Nonnull List<Record> data) {
        int[] columnSizes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnSizes[i] = columns[i].length();
        }
        for (Record record : data) {
            for (int i = 0; i < columns.length; ++i) {
                int len = this.formatValue(record.get(i)).length();
                if (columnSizes[i] >= len) continue;
                columnSizes[i] = len;
            }
        }
        return columnSizes;
    }

    private String formatRecord(StringBuilder sb, int[] columnSizes, Record record) {
        sb.setLength(0);
        return this.formatRow(sb, columnSizes, this.formatValues(record));
    }

    private String[] formatValues(Record record) {
        String[] row = new String[record.size()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.formatValue(record.get(i));
        }
        return row;
    }

    private String formatRow(StringBuilder sb, int[] columnSizes, String[] row) {
        sb.append("|");
        boolean remainder = false;
        for (int i = 0; i < row.length; ++i) {
            sb.append(" ");
            int length2 = columnSizes[i];
            String txt = row[i];
            if (txt != null) {
                if (txt.length() > length2) {
                    if (this.wrap) {
                        sb.append(txt, 0, length2);
                        row[i] = txt.substring(length2);
                        remainder = true;
                    } else {
                        sb.append(txt, 0, length2 - 1);
                        sb.append("\u2026");
                    }
                } else {
                    row[i] = null;
                    sb.append(OutputFormatter.rightPad(txt, length2));
                }
            } else {
                sb.append(OutputFormatter.repeat(' ', length2));
            }
            sb.append(" |");
        }
        if (this.wrap && remainder) {
            sb.append(OutputFormatter.NEWLINE);
            this.formatRow(sb, columnSizes, row);
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String formatFooter(@Nonnull BoltResult result2, int numberOfRows) {
        ResultSummary summary = result2.getSummary();
        return String.format("%d row%s available after %d ms, consumed after another %d ms", numberOfRows, numberOfRows != 1 ? "s" : "", summary.resultAvailableAfter(TimeUnit.MILLISECONDS), summary.resultConsumedAfter(TimeUnit.MILLISECONDS));
    }

    @Override
    @Nonnull
    public String formatInfo(@Nonnull ResultSummary summary) {
        Map<String, Value> info2 = OutputFormatter.info(summary);
        if (info2.isEmpty()) {
            return "";
        }
        String[] columns = info2.keySet().toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        InternalRecord record = new InternalRecord(Arrays.asList(columns), info2.values().toArray(new Value[0]));
        this.formatResultAndCountRows(columns, Collections.singletonList(record).iterator(), sb::append);
        return sb.toString();
    }

    @Override
    @Nonnull
    public String formatPlan(@Nullable ResultSummary summary) {
        if (summary == null || !summary.hasPlan()) {
            return "";
        }
        return new TablePlanFormatter().formatPlan(summary.plan());
    }

    @Override
    public Set<OutputFormatter.Capabilities> capabilities() {
        return EnumSet.allOf(OutputFormatter.Capabilities.class);
    }
}

