/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.schema.IndexDescriptor;

public interface TxStateVisitor
extends AutoCloseable {
    public static final TxStateVisitor EMPTY = new Adapter();
    public static final Decorator NO_DECORATION = txStateVisitor -> txStateVisitor;

    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitCreatedRelationship(long var1, int var3, long var4, long var6) throws ConstraintValidationException;

    public void visitDeletedRelationship(long var1);

    public void visitNodePropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, IntIterable var5) throws ConstraintValidationException;

    public void visitRelPropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, IntIterable var5) throws ConstraintValidationException;

    public void visitGraphPropertyChanges(Iterator<StorageProperty> var1, Iterator<StorageProperty> var2, IntIterable var3);

    public void visitNodeLabelChanges(long var1, LongSet var3, LongSet var4) throws ConstraintValidationException;

    public void visitAddedIndex(IndexDescriptor var1);

    public void visitRemovedIndex(IndexDescriptor var1);

    public void visitAddedConstraint(ConstraintDescriptor var1) throws CreateConstraintFailureException;

    public void visitRemovedConstraint(ConstraintDescriptor var1);

    public void visitCreatedLabelToken(long var1, String var3);

    public void visitCreatedPropertyKeyToken(long var1, String var3);

    public void visitCreatedRelationshipTypeToken(long var1, String var3);

    @Override
    public void close();

    public static interface Decorator
    extends Function<TxStateVisitor, TxStateVisitor> {
    }

    public static class Delegator
    implements TxStateVisitor {
        private final TxStateVisitor actual;

        public Delegator(TxStateVisitor actual2) {
            assert (actual2 != null);
            this.actual = actual2;
        }

        @Override
        public void visitCreatedNode(long id2) {
            this.actual.visitCreatedNode(id2);
        }

        @Override
        public void visitDeletedNode(long id2) {
            this.actual.visitDeletedNode(id2);
        }

        @Override
        public void visitCreatedRelationship(long id2, int type, long startNode, long endNode) throws ConstraintValidationException {
            this.actual.visitCreatedRelationship(id2, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id2) {
            this.actual.visitDeletedRelationship(id2);
        }

        @Override
        public void visitNodePropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.actual.visitNodePropertyChanges(id2, added, changed, removed);
        }

        @Override
        public void visitRelPropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.actual.visitRelPropertyChanges(id2, added, changed, removed);
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
            this.actual.visitGraphPropertyChanges(added, changed, removed);
        }

        @Override
        public void visitNodeLabelChanges(long id2, LongSet added, LongSet removed) throws ConstraintValidationException {
            this.actual.visitNodeLabelChanges(id2, added, removed);
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) {
            this.actual.visitAddedIndex(index);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
            this.actual.visitRemovedIndex(index);
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
            this.actual.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor constraint) {
            this.actual.visitRemovedConstraint(constraint);
        }

        @Override
        public void visitCreatedLabelToken(long id2, String name) {
            this.actual.visitCreatedLabelToken(id2, name);
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id2, String name) {
            this.actual.visitCreatedPropertyKeyToken(id2, name);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id2, String name) {
            this.actual.visitCreatedRelationshipTypeToken(id2, name);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }

    public static class Adapter
    implements TxStateVisitor {
        @Override
        public void visitCreatedNode(long id2) {
        }

        @Override
        public void visitDeletedNode(long id2) {
        }

        @Override
        public void visitCreatedRelationship(long id2, int type, long startNode, long endNode) {
        }

        @Override
        public void visitDeletedRelationship(long id2) {
        }

        @Override
        public void visitNodePropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        }

        @Override
        public void visitRelPropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        }

        @Override
        public void visitNodeLabelChanges(long id2, LongSet added, LongSet removed) {
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor element) throws CreateConstraintFailureException {
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor element) {
        }

        @Override
        public void visitCreatedLabelToken(long id2, String name) {
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id2, String name) {
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id2, String name) {
        }

        @Override
        public void close() {
        }
    }
}

