/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;
import org.neo4j.unsafe.batchinsert.internal.FileSystemClosingBatchInserter;
import org.neo4j.unsafe.batchinsert.internal.IndexConfigStoreProvider;

public final class BatchInserters {
    public static BatchInserter inserter(File databaseDirectory) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter batchInserter = BatchInserters.inserter(databaseDirectory, fileSystem, MapUtil.stringMap(new String[0]));
        return new FileSystemClosingBatchInserter(batchInserter, (IndexConfigStoreProvider)((Object)batchInserter), fileSystem);
    }

    public static BatchInserter inserter(File databaseDirectory, FileSystemAbstraction fs) throws IOException {
        return BatchInserters.inserter(databaseDirectory, fs, MapUtil.stringMap(new String[0]), BatchInserters.loadKernelExtension());
    }

    public static BatchInserter inserter(File databaseDirectory, Map<String, String> config) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter inserter = BatchInserters.inserter(databaseDirectory, fileSystem, config, BatchInserters.loadKernelExtension());
        return new FileSystemClosingBatchInserter(inserter, (IndexConfigStoreProvider)((Object)inserter), fileSystem);
    }

    public static BatchInserter inserter(File databaseDirectory, FileSystemAbstraction fs, Map<String, String> config) throws IOException {
        return BatchInserters.inserter(databaseDirectory, fs, config, BatchInserters.loadKernelExtension());
    }

    public static BatchInserter inserter(File databaseDirectory, Map<String, String> config, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserterImpl inserter = new BatchInserterImpl(databaseDirectory, fileSystem, config, kernelExtensions);
        return new FileSystemClosingBatchInserter(inserter, inserter, fileSystem);
    }

    public static BatchInserter inserter(File databaseDirectory, FileSystemAbstraction fileSystem, Map<String, String> config, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        return new BatchInserterImpl(databaseDirectory, fileSystem, config, kernelExtensions);
    }

    private static DefaultFileSystemAbstraction createFileSystem() {
        return new DefaultFileSystemAbstraction();
    }

    private static Iterable loadKernelExtension() {
        return Service.load(KernelExtensionFactory.class);
    }
}

