/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordNodeCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

abstract class BatchRelationshipIterable<T>
implements Iterable<T> {
    private final StorageRelationshipTraversalCursor relationshipCursor;

    BatchRelationshipIterable(RecordStorageReader storageReader, long nodeId) {
        this.relationshipCursor = storageReader.allocateRelationshipTraversalCursor();
        RecordNodeCursor nodeCursor = storageReader.allocateNodeCursor();
        nodeCursor.single(nodeId);
        if (!nodeCursor.next()) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
        this.relationshipCursor.init(nodeId, nodeCursor.allRelationshipsReference());
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){

            @Override
            protected T fetchNextOrNull() {
                if (!BatchRelationshipIterable.this.relationshipCursor.next()) {
                    return null;
                }
                return BatchRelationshipIterable.this.nextFrom(BatchRelationshipIterable.this.relationshipCursor.entityReference(), BatchRelationshipIterable.this.relationshipCursor.type(), BatchRelationshipIterable.this.relationshipCursor.sourceNodeReference(), BatchRelationshipIterable.this.relationshipCursor.targetNodeReference());
            }
        };
    }

    protected abstract T nextFrom(long var1, int var3, long var4, long var6);
}

