/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.helpers.collection.Iterators;

public class DataStatistics
implements Iterable<RelationshipTypeCount> {
    private final List<Client> clients = new ArrayList<Client>();
    private int opened;
    private RelationshipTypeCount[] typeCounts;
    private final long nodeCount;
    private final long propertyCount;

    public DataStatistics(long nodeCount, long propertyCount, RelationshipTypeCount[] sortedTypes) {
        this.nodeCount = nodeCount;
        this.propertyCount = propertyCount;
        this.typeCounts = sortedTypes;
    }

    @Override
    public Iterator<RelationshipTypeCount> iterator() {
        return Iterators.iterator(this.typeCounts);
    }

    public int getNumberOfRelationshipTypes() {
        return this.typeCounts.length;
    }

    public synchronized Client newClient() {
        Client client = new Client();
        this.clients.add(client);
        ++this.opened;
        return client;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void closeClient() {
        if (--this.opened == 0) {
            void var3_6;
            int highestTypeId = 0;
            for (Client client : this.clients) {
                highestTypeId = Integer.max(highestTypeId, client.highestTypeId);
            }
            long[] counts = new long[highestTypeId + 1];
            for (Client client : this.clients) {
                client.addTo(counts);
            }
            this.typeCounts = new RelationshipTypeCount[counts.length];
            boolean bl = false;
            while (var3_6 < counts.length) {
                this.typeCounts[var3_6] = new RelationshipTypeCount((int)var3_6, counts[var3_6]);
                ++var3_6;
            }
            Arrays.sort(this.typeCounts);
        }
    }

    public RelationshipTypeCount get(int index) {
        return this.typeCounts[index];
    }

    public IntSet types(int startingFromType, int upToType) {
        IntHashSet set = new IntHashSet((upToType - startingFromType) * 2);
        for (int i = startingFromType; i < upToType; ++i) {
            set.add(this.get(i).getTypeId());
        }
        return set;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public long getPropertyCount() {
        return this.propertyCount;
    }

    public long getRelationshipCount() {
        long sum2 = 0L;
        for (RelationshipTypeCount type : this.typeCounts) {
            sum2 += type.count;
        }
        return sum2;
    }

    public String toString() {
        return String.format("Imported:%n  %d nodes%n  %d relationships%n  %d properties", this.nodeCount, this.getRelationshipCount(), this.propertyCount);
    }

    public class Client
    implements AutoCloseable {
        private long[] counts = new long[8];
        private int highestTypeId;

        public void increment(int typeId) {
            if (typeId >= this.counts.length) {
                this.counts = Arrays.copyOf(this.counts, Integer.max(this.counts.length * 2, typeId + 1));
            }
            int n = typeId;
            this.counts[n] = this.counts[n] + 1L;
            if (typeId > this.highestTypeId) {
                this.highestTypeId = typeId;
            }
        }

        @Override
        public void close() {
            DataStatistics.this.closeClient();
        }

        private void addTo(long[] counts) {
            for (int i = 0; i <= this.highestTypeId; ++i) {
                int n = i;
                counts[n] = counts[n] + this.counts[i];
            }
        }
    }

    public static class RelationshipTypeCount
    implements Comparable<RelationshipTypeCount> {
        private final int typeId;
        private final long count;

        public RelationshipTypeCount(int typeId, long count2) {
            this.typeId = typeId;
            this.count = count2;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public long getCount() {
            return this.count;
        }

        @Override
        public int compareTo(RelationshipTypeCount o) {
            return Long.compare(this.count, o.count);
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (int)(this.count ^ this.count >>> 32);
            result2 = 31 * result2 + this.typeId;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelationshipTypeCount other2 = (RelationshipTypeCount)obj;
            return this.count == other2.count && this.typeId == other2.typeId;
        }

        public String toString() {
            return String.format("%s[type:%d, count:%d]", this.getClass().getSimpleName(), this.typeId, this.count);
        }
    }
}

