/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Format;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.unsafe.impl.batchimport.HeapSizeSanityChecker;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsAndLabelIndexBuildStage;
import org.neo4j.unsafe.impl.batchimport.NodeDegreeCountStage;
import org.neo4j.unsafe.impl.batchimport.NodeInputIdPropertyLookup;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkforwardStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkingProgress;
import org.neo4j.unsafe.impl.batchimport.SparseNodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.EstimationSanityChecker;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class ImportLogic
implements Closeable {
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void mayExceedRelationshipIdCapacity(long capacity, long estimatedCount) {
        }

        @Override
        public void mayExceedNodeIdCapacity(long capacity, long estimatedCount) {
        }

        @Override
        public void doubleRelationshipRecordUnitsEnabled() {
        }

        @Override
        public void insufficientHeapSize(long optimalMinimalHeapSize, long heapSize) {
        }

        @Override
        public void abundantHeapSize(long optimalMinimalHeapSize, long heapSize) {
        }

        @Override
        public void insufficientAvailableMemory(long estimatedCacheSize, long optimalMinimalHeapSize, long availableMemory) {
        }
    };
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final BatchingNeoStores neoStore;
    private final Configuration config;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final RecordFormats recordFormats;
    private final DataImporter.Monitor storeUpdateMonitor = new DataImporter.Monitor();
    private final long maxMemory;
    private final Dependencies dependencies = new Dependencies();
    private final Monitor monitor;
    private Input input;
    private boolean successful;
    private final Map<Class<?>, Object> accessibleState = new HashMap();
    private NodeRelationshipCache nodeRelationshipCache;
    private NodeLabelsCache nodeLabelsCache;
    private long startTime;
    private NumberArrayFactory numberArrayFactory;
    private Collector badCollector;
    private IdMapper idMapper;
    private long peakMemoryUsage;
    private long availableMemoryForLinking;

    public ImportLogic(File storeDir, FileSystemAbstraction fileSystem, BatchingNeoStores neoStore, Configuration config, LogService logService, ExecutionMonitor executionMonitor, RecordFormats recordFormats, Monitor monitor) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.neoStore = neoStore;
        this.config = config;
        this.recordFormats = recordFormats;
        this.monitor = monitor;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config);
        this.maxMemory = config.maxMemoryUsage();
    }

    public void initialize(Input input2) throws IOException {
        this.log.info("Import starting");
        this.startTime = System.currentTimeMillis();
        this.input = input2;
        PageCacheArrayFactoryMonitor numberArrayFactoryMonitor = new PageCacheArrayFactoryMonitor();
        this.numberArrayFactory = NumberArrayFactory.auto(this.neoStore.getPageCache(), this.storeDir, this.config.allowCacheAllocationOnHeap(), numberArrayFactoryMonitor);
        this.badCollector = input2.badCollector();
        this.idMapper = input2.idMapper(this.numberArrayFactory);
        this.nodeRelationshipCache = new NodeRelationshipCache(this.numberArrayFactory, this.config.denseNodeThreshold());
        Input.Estimates inputEstimates = input2.calculateEstimates(this.neoStore.getPropertyStore().newValueEncodedSizeCalculator());
        new EstimationSanityChecker(this.recordFormats, this.monitor).sanityCheck(inputEstimates);
        new HeapSizeSanityChecker(this.monitor).sanityCheck(inputEstimates, this.recordFormats, this.neoStore, this.nodeRelationshipCache.memoryEstimation(inputEstimates.numberOfNodes()), this.idMapper.memoryEstimation(inputEstimates.numberOfNodes()));
        this.dependencies.satisfyDependencies(inputEstimates, this.idMapper, this.neoStore, this.nodeRelationshipCache, numberArrayFactoryMonitor);
        if (this.neoStore.determineDoubleRelationshipRecordUnits(inputEstimates)) {
            this.monitor.doubleRelationshipRecordUnitsEnabled();
        }
        this.executionMonitor.initialize(this.dependencies);
    }

    public <T> T getState(Class<T> type) {
        return type.cast(this.accessibleState.get(type));
    }

    public <T> void putState(T state) {
        this.accessibleState.put(state.getClass(), state);
        this.dependencies.satisfyDependency(state);
    }

    public void importNodes() throws IOException {
        this.neoStore.startFlushingPageCache();
        DataImporter.importNodes(this.config.maxNumberOfProcessors(), this.input, this.neoStore, this.idMapper, this.executionMonitor, this.storeUpdateMonitor);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
    }

    public void prepareIdMapper() {
        if (this.idMapper.needsPreparation()) {
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.idMapper);
            NodeInputIdPropertyLookup inputIdLookup = new NodeInputIdPropertyLookup(this.neoStore.getTemporaryPropertyStore());
            this.executeStage(new IdMapperPreparationStage(this.config, this.idMapper, inputIdLookup, this.badCollector, memoryUsageStats));
            LongIterator duplicateNodeIds = this.idMapper.leftOverDuplicateNodesIds();
            if (duplicateNodeIds.hasNext()) {
                this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, this.neoStore, this.storeUpdateMonitor));
            }
            this.updatePeakMemoryUsage();
        }
    }

    public void importRelationships() throws IOException {
        this.neoStore.startFlushingPageCache();
        DataStatistics typeDistribution = DataImporter.importRelationships(this.config.maxNumberOfProcessors(), this.input, this.neoStore, this.idMapper, this.badCollector, this.executionMonitor, this.storeUpdateMonitor, !this.badCollector.isCollectingBadRelationships());
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
        this.idMapper.close();
        this.idMapper = null;
        this.putState(typeDistribution);
    }

    public void calculateNodeDegrees() {
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        this.nodeRelationshipCache.setNodeCount(this.neoStore.getNodeStore().getHighId());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeRelationshipCache);
        NodeDegreeCountStage nodeDegreeStage = new NodeDegreeCountStage(relationshipConfig, this.neoStore.getRelationshipStore(), this.nodeRelationshipCache, memoryUsageStats);
        this.executeStage(nodeDegreeStage);
        this.nodeRelationshipCache.countingCompleted();
        this.availableMemoryForLinking = this.maxMemory - ImportLogic.totalMemoryUsageOf(this.nodeRelationshipCache, this.neoStore);
    }

    public int linkRelationships(int startingFromType) {
        assert (startingFromType >= 0) : startingFromType;
        DataStatistics relationshipTypeDistribution = this.getState(DataStatistics.class);
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeRelationshipCache);
        int upToType = ImportLogic.nextSetOfTypesThatFitInMemory(relationshipTypeDistribution, startingFromType, this.availableMemoryForLinking, this.nodeRelationshipCache.getNumberOfDenseNodes());
        IntSet typesToLinkThisRound = relationshipTypeDistribution.types(startingFromType, upToType);
        int typesImported = typesToLinkThisRound.size();
        boolean thisIsTheFirstRound = startingFromType == 0;
        boolean thisIsTheOnlyRound = thisIsTheFirstRound && upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes();
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        Configuration nodeConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getNodeStore());
        Configuration groupConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipGroupStore());
        this.nodeRelationshipCache.setForwardScan(true, true);
        String range2 = typesToLinkThisRound.size() == 1 ? String.valueOf(ImportLogic.oneBased(startingFromType)) : ImportLogic.oneBased(startingFromType) + "-" + (startingFromType + typesImported);
        String topic = " " + range2 + "/" + relationshipTypeDistribution.getNumberOfRelationshipTypes();
        int nodeTypes = thisIsTheFirstRound ? 3 : 1;
        Predicate<RelationshipRecord> readFilter = thisIsTheFirstRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        Predicate<RelationshipRecord> denseChangeFilter = thisIsTheOnlyRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        RelationshipLinkforwardStage linkForwardStage = new RelationshipLinkforwardStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, new RelationshipLinkingProgress(), memoryUsageStats);
        this.executeStage(linkForwardStage);
        this.executeStage(new RelationshipGroupStage(topic, groupConfig, this.neoStore.getTemporaryRelationshipGroupStore(), this.nodeRelationshipCache));
        if (thisIsTheFirstRound) {
            this.executeStage(new SparseNodeFirstRelationshipStage(nodeConfig, this.neoStore.getNodeStore(), this.nodeRelationshipCache));
        }
        this.nodeRelationshipCache.setForwardScan(false, true);
        this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, new RelationshipLinkingProgress(), memoryUsageStats));
        this.updatePeakMemoryUsage();
        if (upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes()) {
            this.nodeRelationshipCache.close();
            this.nodeRelationshipCache = null;
            return -1;
        }
        return upToType;
    }

    public void linkRelationshipsOfAllTypes() {
        int type = 0;
        while ((type = this.linkRelationships(type)) != -1) {
        }
    }

    private static int oneBased(int value2) {
        return value2 + 1;
    }

    static int nextSetOfTypesThatFitInMemory(DataStatistics typeDistribution, int startingFromType, long freeMemoryForDenseNodeCache, long numberOfDenseNodes) {
        DataStatistics.RelationshipTypeCount type;
        long relationshipCountForThisType;
        long memoryUsageUpToAndIncludingThisType;
        int toType;
        long memoryUsageForThisType;
        assert (startingFromType >= 0) : startingFromType;
        long currentSetOfRelationshipsMemoryUsage = 0L;
        int numberOfTypes = typeDistribution.getNumberOfRelationshipTypes();
        for (toType = startingFromType; toType < numberOfTypes && ((memoryUsageUpToAndIncludingThisType = currentSetOfRelationshipsMemoryUsage + (memoryUsageForThisType = NodeRelationshipCache.calculateMaxMemoryUsage(numberOfDenseNodes, relationshipCountForThisType = (type = typeDistribution.get(toType)).getCount()))) <= freeMemoryForDenseNodeCache || currentSetOfRelationshipsMemoryUsage <= 0L); currentSetOfRelationshipsMemoryUsage += memoryUsageForThisType, ++toType) {
        }
        return toType;
    }

    public void defragmentRelationshipGroups() {
        new RelationshipGroupDefragmenter(this.config, this.executionMonitor, RelationshipGroupDefragmenter.Monitor.EMPTY, this.numberArrayFactory).run(Long.max(this.maxMemory, this.peakMemoryUsage), this.neoStore, this.neoStore.getNodeStore().getHighId());
    }

    public void buildCountsStore() {
        try (CountsAccessor.Updater countsUpdater = this.neoStore.getCountsStore().reset(this.neoStore.getLastCommittedTransactionId());){
            SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
            this.nodeLabelsCache = new NodeLabelsCache(this.numberArrayFactory, this.neoStore.getLabelRepository().getHighId());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeLabelsCache);
            this.executeStage(new NodeCountsAndLabelIndexBuildStage(this.config, this.nodeLabelsCache, this.neoStore.getNodeStore(), this.neoStore.getLabelRepository().getHighId(), countsUpdater, progressMonitor.startSection("Nodes"), this.neoStore.getLabelScanStore(), memoryUsageStats));
            this.executeStage(new RelationshipCountsStage(this.config, this.nodeLabelsCache, this.neoStore.getRelationshipStore(), this.neoStore.getLabelRepository().getHighId(), this.neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, this.numberArrayFactory, progressMonitor.startSection("Relationships")));
        }
    }

    public void success() {
        this.neoStore.success();
        this.successful = true;
    }

    @Override
    public void close() throws IOException {
        long totalTimeMillis = System.currentTimeMillis() - this.startTime;
        DataStatistics state = this.getState(DataStatistics.class);
        String additionalInformation = Objects.toString(state, "Data statistics is not available.");
        this.executionMonitor.done(this.successful, totalTimeMillis, String.format("%n%s%nPeak memory usage: %s", additionalInformation, Format.bytes(this.peakMemoryUsage)));
        this.log.info("Import completed successfully, took " + Format.duration(totalTimeMillis) + ". " + additionalInformation);
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nodeRelationshipCache, this.nodeLabelsCache, this.idMapper});
    }

    private void updatePeakMemoryUsage() {
        this.peakMemoryUsage = Long.max(this.peakMemoryUsage, ImportLogic.totalMemoryUsageOf(this.nodeRelationshipCache, this.idMapper, this.neoStore));
    }

    public static BatchingNeoStores instantiateNeoStores(FileSystemAbstraction fileSystem, File storeDir, PageCache externalPageCache, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds additionalInitialIds, Config dbConfig, JobScheduler scheduler) {
        if (externalPageCache == null) {
            return BatchingNeoStores.batchingNeoStores(fileSystem, storeDir, recordFormats, config, logService, additionalInitialIds, dbConfig, scheduler);
        }
        return BatchingNeoStores.batchingNeoStoresWithExternalPageCache(fileSystem, externalPageCache, PageCacheTracer.NULL, storeDir, recordFormats, config, logService, additionalInitialIds, dbConfig);
    }

    private static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total2 = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            if (user == null) continue;
            user.acceptMemoryStatsVisitor(total2);
        }
        return total2.getHeapUsage() + total2.getOffHeapUsage();
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, RecordStore<?> store) {
        return Configuration.withBatchSize(source, store.getRecordsPerPage() * 10);
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, stage);
    }

    public static interface Monitor {
        public void doubleRelationshipRecordUnitsEnabled();

        public void mayExceedNodeIdCapacity(long var1, long var3);

        public void mayExceedRelationshipIdCapacity(long var1, long var3);

        public void insufficientHeapSize(long var1, long var3);

        public void abundantHeapSize(long var1, long var3);

        public void insufficientAvailableMemory(long var1, long var3, long var5);
    }
}

