/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Supplier;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.ProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.RecordDataAssembler;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadGroupRecordsByCacheStep
extends ProducerStep {
    private final RecordStore<RelationshipGroupRecord> store;
    private final NodeRelationshipCache cache;

    public ReadGroupRecordsByCacheStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, NodeRelationshipCache cache) {
        super(control, config);
        this.store = store;
        this.cache = cache;
    }

    @Override
    protected void process() {
        try (NodeVisitor visitor = new NodeVisitor();){
            this.cache.visitChangedNodes(visitor, 1);
        }
    }

    @Override
    protected long position() {
        return this.store.getHighId() * (long)this.store.getRecordSize();
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable,
    NodeRelationshipCache.GroupVisitor,
    Supplier<RelationshipGroupRecord[]> {
        private final RecordDataAssembler<RelationshipGroupRecord> assembler = new RecordDataAssembler<RelationshipGroupRecord>(ReadGroupRecordsByCacheStep.access$100(ReadGroupRecordsByCacheStep.this)::newRecord);
        private RelationshipGroupRecord[] batch = this.get();
        private int cursor;
        private long time = System.nanoTime();

        private NodeVisitor() {
        }

        @Override
        public void change(long nodeId, ByteArray array) {
            ReadGroupRecordsByCacheStep.this.cache.getFirstRel(nodeId, this);
        }

        @Override
        public long visit(long nodeId, int typeId, long out, long in2, long loop2) {
            long id2 = ReadGroupRecordsByCacheStep.this.store.nextId();
            RelationshipGroupRecord record = this.batch[this.cursor++];
            record.setId(id2);
            record.initialize(true, typeId, out, in2, loop2, nodeId, loop2);
            if (this.cursor == ReadGroupRecordsByCacheStep.this.batchSize) {
                this.send();
                this.batch = ReadGroupRecordsByCacheStep.this.control.reuse(this);
                this.cursor = 0;
            }
            return id2;
        }

        private void send() {
            ReadGroupRecordsByCacheStep.this.totalProcessingTime.add(System.nanoTime() - this.time);
            ReadGroupRecordsByCacheStep.this.sendDownstream(this.batch);
            this.time = System.nanoTime();
            ReadGroupRecordsByCacheStep.this.assertHealthy();
        }

        @Override
        public void close() {
            if (this.cursor > 0) {
                this.batch = (RelationshipGroupRecord[])this.assembler.cutOffAt(this.batch, this.cursor);
                this.send();
            }
        }

        @Override
        public RelationshipGroupRecord[] get() {
            return (RelationshipGroupRecord[])this.assembler.newBatchObject(ReadGroupRecordsByCacheStep.this.batchSize);
        }
    }
}

