/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.ProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadNodeIdsByCacheStep
extends ProducerStep {
    private final int nodeTypes;
    private final NodeRelationshipCache cache;
    private volatile long highId;

    public ReadNodeIdsByCacheStep(StageControl control, Configuration config, NodeRelationshipCache cache, int nodeTypes) {
        super(control, config);
        this.cache = cache;
        this.nodeTypes = nodeTypes;
    }

    @Override
    protected void process() {
        try (NodeVisitor visitor = new NodeVisitor();){
            this.cache.visitChangedNodes(visitor, this.nodeTypes);
        }
    }

    @Override
    protected long position() {
        return this.highId * 8L;
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable {
        private long[] batch;
        private int cursor;
        private long time;

        private NodeVisitor() {
            this.batch = new long[ReadNodeIdsByCacheStep.this.batchSize];
            this.time = System.nanoTime();
        }

        @Override
        public void change(long nodeId, ByteArray array) {
            this.batch[this.cursor++] = nodeId;
            if (this.cursor == ReadNodeIdsByCacheStep.this.batchSize) {
                this.send();
                this.batch = new long[ReadNodeIdsByCacheStep.this.batchSize];
                this.cursor = 0;
            }
        }

        private void send() {
            ReadNodeIdsByCacheStep.this.totalProcessingTime.add(System.nanoTime() - this.time);
            ReadNodeIdsByCacheStep.this.sendDownstream(PrimitiveLongCollections.iterator(this.batch));
            this.time = System.nanoTime();
            ReadNodeIdsByCacheStep.this.assertHealthy();
            ReadNodeIdsByCacheStep.this.highId = this.batch[this.cursor - 1];
        }

        @Override
        public void close() {
            if (this.cursor > 0) {
                this.batch = Arrays.copyOf(this.batch, this.cursor);
                this.send();
            }
        }
    }
}

