/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Predicate;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStep;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.BatchFeedStep;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.RecordDataAssembler;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;

public class RelationshipLinkbackStage
extends Stage {
    public static final String NAME = "Relationship <-- Relationship";

    public RelationshipLinkbackStage(String topic, Configuration config, BatchingNeoStores stores, NodeRelationshipCache cache, Predicate<RelationshipRecord> readFilter, Predicate<RelationshipRecord> changeFilter, int nodeTypes, StatsProvider ... additionalStatsProvider) {
        super(NAME, topic, config, 3);
        RelationshipStore store = stores.getRelationshipStore();
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.backwards(0L, store.getHighId(), config), store.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipRecord>(this.control(), config, true, store, new RecordDataAssembler<RelationshipRecord>(store::newRecord, readFilter)));
        this.add(new RelationshipLinkbackStep(this.control(), config, cache, changeFilter, nodeTypes, additionalStatsProvider));
        this.add(new UpdateRecordsStep<RelationshipRecord>(this.control(), config, store, PrepareIdSequence.of(stores.usesDoubleRelationshipRecordUnits())));
    }
}

