/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class RelationshipLinkbackStep
extends RelationshipLinkStep {
    public RelationshipLinkbackStep(StageControl control, Configuration config, NodeRelationshipCache cache, Predicate<RelationshipRecord> filter2, int nodeTypes, StatsProvider ... additionalStatsProvider) {
        super(control, config, cache, filter2, nodeTypes, false, additionalStatsProvider);
    }

    @Override
    protected void linkStart(RelationshipRecord record) {
        int typeId = record.getType();
        long firstPrevRel = this.cache.getAndPutRelationship(record.getFirstNode(), typeId, Direction.OUTGOING, record.getId(), false);
        if (firstPrevRel == -1L) {
            record.setFirstInFirstChain(true);
            firstPrevRel = this.cache.getCount(record.getFirstNode(), typeId, Direction.OUTGOING);
        }
        record.setFirstPrevRel(firstPrevRel);
    }

    @Override
    protected void linkEnd(RelationshipRecord record) {
        int typeId = record.getType();
        long secondPrevRel = this.cache.getAndPutRelationship(record.getSecondNode(), typeId, Direction.INCOMING, record.getId(), false);
        if (secondPrevRel == -1L) {
            record.setFirstInSecondChain(true);
            secondPrevRel = this.cache.getCount(record.getSecondNode(), typeId, Direction.INCOMING);
        }
        record.setSecondPrevRel(secondPrevRel);
    }

    @Override
    protected void linkLoop(RelationshipRecord record) {
        int typeId = record.getType();
        long prevRel = this.cache.getAndPutRelationship(record.getFirstNode(), typeId, Direction.BOTH, record.getId(), false);
        if (prevRel == -1L) {
            record.setFirstInFirstChain(true);
            record.setFirstInSecondChain(true);
            prevRel = this.cache.getCount(record.getFirstNode(), typeId, Direction.BOTH);
        }
        record.setFirstPrevRel(prevRel);
        record.setSecondPrevRel(prevRel);
    }
}

