/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArray;

public class PageCacheByteArray
extends PageCacheNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;

    PageCacheByteArray(PagedFile pagedFile, long length2, byte[] defaultValue, long base) throws IOException {
        super(pagedFile, defaultValue.length, length2, base);
        this.defaultValue = defaultValue;
        this.setDefaultValue(-1L);
    }

    @Override
    protected void fillPageWithDefaultValue(PageCursor writeCursor, long ignoredDefaultValue, int pageSize) {
        for (int i = 0; i < this.entriesPerPage; ++i) {
            writeCursor.putBytes(this.defaultValue);
        }
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        long fromPageId = this.pageId(fromIndex);
        int fromOffset = this.offset(fromIndex);
        long toPageId = this.pageId(toIndex);
        int toOffset = this.offset(toIndex);
        try (PageCursor fromCursor = this.pagedFile.io(fromPageId, 2);
             PageCursor toCursor = this.pagedFile.io(toPageId, 2);){
            fromCursor.next();
            toCursor.next();
            int i = 0;
            while (i < this.entrySize) {
                byte intermediary = fromCursor.getByte(fromOffset);
                fromCursor.putByte(fromOffset, toCursor.getByte(toOffset));
                toCursor.putByte(toOffset, intermediary);
                ++i;
                ++fromOffset;
                ++toOffset;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void get(long index, byte[] into) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            cursor.next();
            do {
                for (int i = 0; i < into.length; ++i) {
                    into[i] = cursor.getByte(offset + i);
                }
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte getByte(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            byte result2;
            cursor.next();
            do {
                result2 = cursor.getByte(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            byte by2 = result2;
            return by2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public short getShort(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            short result2;
            cursor.next();
            do {
                result2 = cursor.getShort(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            short s2 = result2;
            return s2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            int result2;
            cursor.next();
            do {
                result2 = cursor.getInt(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            int n = result2;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long get5ByteLong(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            long result2;
            cursor.next();
            do {
                long low4b = (long)cursor.getInt(offset) & 0xFFFFFFFFL;
                long high1b = cursor.getByte(offset + 4) & 0xFF;
                result2 = low4b | high1b << 32;
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            long l = result2 == 0xFFFFFFFFFFL ? -1L : result2;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long get6ByteLong(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            long result2;
            cursor.next();
            do {
                long low4b = (long)cursor.getInt(offset) & 0xFFFFFFFFL;
                long high2b = cursor.getShort(offset + 4) & 0xFFFF;
                result2 = low4b | high2b << 32;
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            long l = result2 == 0xFFFFFFFFFFFFL ? -1L : result2;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            long result2;
            cursor.next();
            do {
                result2 = cursor.getLong(offset);
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            long l = result2;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set(long index, byte[] value2) {
        assert (value2.length == this.entrySize);
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            for (int i = 0; i < value2.length; ++i) {
                cursor.putByte(offset + i, value2[i]);
            }
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setByte(long index, int offset, byte value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putByte(offset, value2);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setShort(long index, int offset, short value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putShort(offset, value2);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setInt(long index, int offset, int value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putInt(offset, value2);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set5ByteLong(long index, int offset, long value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putInt(offset, (int)value2);
            cursor.putByte(offset + 4, (byte)(value2 >>> 32));
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set6ByteLong(long index, int offset, long value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putInt(offset, (int)value2);
            cursor.putShort(offset + 4, (short)(value2 >>> 32));
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setLong(long index, int offset, long value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putLong(offset, value2);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int get3ByteInt(long index, int offset) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            int result2;
            cursor.next();
            do {
                int lowWord = cursor.getShort(offset) & 0xFFFF;
                int highByte = cursor.getByte(offset + 2) & 0xFF;
                result2 = lowWord | highByte << 16;
            } while (cursor.shouldRetry());
            this.checkBounds(cursor);
            int n = result2 == 0xFFFFFF ? -1 : result2;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set3ByteInt(long index, int offset, int value2) {
        long pageId = this.pageId(index);
        offset += this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putShort(offset, (short)value2);
            cursor.putByte(offset + 2, (byte)(value2 >>> 16));
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

