/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.AbstractTracker;

public class IntTracker
extends AbstractTracker<IntArray> {
    static final int SIZE = 4;
    static final int ID_BITS = 31;
    static final long MAX_ID = Integer.MAX_VALUE;
    static final int DEFAULT_VALUE = -1;
    private static final LongBitsManipulator BITS = new LongBitsManipulator(31, 1);

    public IntTracker(IntArray array) {
        super(array);
    }

    @Override
    public long get(long index) {
        return BITS.get(((IntArray)this.array).get(index), 0);
    }

    @Override
    public void set(long index, long value2) {
        long field2 = ((IntArray)this.array).get(index);
        field2 = BITS.set(field2, 0, value2);
        ((IntArray)this.array).set(index, (int)field2);
    }

    @Override
    public void markAsDuplicate(long index) {
        long field2 = ((IntArray)this.array).get(index);
        field2 = BITS.set(field2, 1, 0L);
        ((IntArray)this.array).set(index, (int)field2);
    }

    @Override
    public boolean isMarkedAsDuplicate(long index) {
        long field2 = ((IntArray)this.array).get(index);
        return BITS.get(field2, 1) == 0L;
    }
}

