/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionValues;

public class LongCollisionValues
implements CollisionValues {
    private final LongArray cache;
    private long nextOffset;

    public LongCollisionValues(NumberArrayFactory factory, long length2) {
        this.cache = factory.newLongArray(length2, 0L);
    }

    @Override
    public long add(Object id2) {
        long collisionIndex = this.nextOffset++;
        this.cache.set(collisionIndex, ((Number)id2).longValue());
        return collisionIndex;
    }

    @Override
    public Object get(long offset) {
        return this.cache.get(offset);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

