/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.string.UTF8;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionValues;

public class StringCollisionValues
implements CollisionValues {
    private final long chunkSize;
    private final ByteArray cache;
    private long offset;
    private ByteArray current;

    public StringCollisionValues(NumberArrayFactory factory, long length2) {
        int remainder = (int)(length2 % 8192L);
        if (remainder != 0) {
            length2 += (long)(8192 - remainder);
        }
        this.chunkSize = Long.max(length2, 8192L);
        this.cache = factory.newDynamicByteArray(this.chunkSize, new byte[1]);
        this.current = (ByteArray)this.cache.at(0L);
    }

    @Override
    public long add(Object id2) {
        String string2 = (String)id2;
        byte[] bytes2 = UTF8.encode(string2);
        int length2 = bytes2.length;
        if (length2 > 65535) {
            throw new IllegalArgumentException(string2);
        }
        long startOffset = this.offset;
        this.cache.setByte(this.offset++, 0, (byte)length2);
        this.cache.setByte(this.offset++, 0, (byte)(length2 >>> 8));
        this.current = (ByteArray)this.cache.at(this.offset);
        int i = 0;
        while (i < length2) {
            int bytesLeftToWrite = length2 - i;
            int bytesLeftInChunk = (int)(this.chunkSize - this.offset % this.chunkSize);
            int bytesToWriteInThisChunk = Integer.min(bytesLeftToWrite, bytesLeftInChunk);
            for (int j = 0; j < bytesToWriteInThisChunk; ++j) {
                this.current.setByte(this.offset++, 0, bytes2[i++]);
            }
            if (length2 <= i) continue;
            this.current = (ByteArray)this.cache.at(this.offset);
        }
        return startOffset;
    }

    @Override
    public Object get(long offset) {
        int length2 = this.cache.getByte(offset++, 0) & 0xFF;
        long l = offset++;
        ByteArray array = (ByteArray)this.cache.at(offset);
        byte[] bytes2 = new byte[length2 |= (this.cache.getByte(l, 0) & 0xFF) << 8];
        int i = 0;
        while (i < length2) {
            int bytesLeftToRead = length2 - i;
            int bytesLeftInChunk = (int)(this.chunkSize - offset % this.chunkSize);
            int bytesToReadInThisChunk = Integer.min(bytesLeftToRead, bytesLeftInChunk);
            for (int j = 0; j < bytesToReadInThisChunk; ++j) {
                bytes2[i++] = array.getByte(offset++, 0);
            }
            if (length2 <= i) continue;
            array = (ByteArray)this.cache.at(offset);
        }
        return UTF8.decode(bytes2);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

