/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.ClosestNewLineChunker;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.Source;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvGroupInputIterator;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInputChunk;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.EagerCsvInputChunk;
import org.neo4j.unsafe.impl.batchimport.input.csv.EagerParserChunker;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.LazyCsvInputChunk;

class CsvInputIterator
implements SourceTraceability,
Closeable {
    private final CharReadable stream;
    private final Chunker chunker;
    private final int groupId;
    private final Decorator decorator;
    private final Supplier<CsvInputChunk> realInputChunkSupplier;

    CsvInputIterator(CharReadable stream, Decorator decorator, Header header, Configuration config, IdType idType, Collector badCollector, Extractors extractors, int groupId) {
        this.stream = stream;
        this.decorator = decorator;
        this.groupId = groupId;
        if (config.multilineFields()) {
            this.chunker = new EagerParserChunker(stream, idType, header, badCollector, extractors, 1000, config, decorator);
            this.realInputChunkSupplier = EagerCsvInputChunk::new;
        } else {
            this.chunker = new ClosestNewLineChunker(stream, config.bufferSize());
            this.realInputChunkSupplier = () -> new LazyCsvInputChunk(idType, config.delimiter(), badCollector, CsvGroupInputIterator.extractors(config), this.chunker.newChunk(), config, decorator, header);
        }
    }

    CsvInputIterator(CharReadable stream, Decorator decorator, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups, Collector badCollector, Extractors extractors, int groupId) throws IOException {
        this(stream, decorator, CsvInputIterator.extractHeader(stream, headerFactory, idType, config, groups), config, idType, badCollector, extractors, groupId);
    }

    static Header extractHeader(CharReadable stream, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups) throws IOException {
        if (!headerFactory.isDefined()) {
            char[] firstLineBuffer = Readables.extractFirstLineFrom(stream);
            CharReadableChunker.ChunkImpl firstChunk = new CharReadableChunker.ChunkImpl(Arrays.copyOf(firstLineBuffer, firstLineBuffer.length + 1));
            firstChunk.initialize(firstLineBuffer.length, stream.sourceDescription());
            CharSeeker firstSeeker = CsvInputIterator.seeker(firstChunk, config);
            return headerFactory.create(firstSeeker, config, idType, groups);
        }
        return headerFactory.create(null, null, null, null);
    }

    public boolean next(CsvInputChunkProxy proxy) throws IOException {
        proxy.ensureInstantiated(this.realInputChunkSupplier, this.groupId);
        return proxy.fillFrom(this.chunker);
    }

    @Override
    public void close() throws IOException {
        this.chunker.close();
        this.decorator.close();
    }

    @Override
    public String sourceDescription() {
        return this.stream.sourceDescription();
    }

    @Override
    public long position() {
        return this.chunker.position();
    }

    static CharSeeker seeker(Source.Chunk chunk, Configuration config) {
        return new BufferedCharSeeker(Source.singleChunk(chunk), config);
    }
}

