/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.QuantizedProjection;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class SpectrumExecutionMonitor
extends ExecutionMonitor.Adapter {
    public static final int DEFAULT_WIDTH = 100;
    private static final int PROGRESS_WIDTH = 5;
    private static final char[] WEIGHTS = new char[]{' ', 'K', 'M', 'B', 'T'};
    private final PrintStream out;
    private final int width;
    private long lastProgress;

    public SpectrumExecutionMonitor(long interval, TimeUnit unit, PrintStream out, int width) {
        super(interval, unit);
        this.out = out;
        this.width = width;
    }

    @Override
    public void start(StageExecution execution) {
        this.out.println(execution.name() + ", started " + Format.date());
        this.lastProgress = 0L;
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
        this.check(execution);
        this.out.println();
        this.out.println("Done in " + Format.duration(totalTimeMillis));
    }

    @Override
    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        this.out.println();
        this.out.println(String.format("IMPORT %s in %s. %s", successful ? "DONE" : "FAILED", Format.duration(totalTimeMillis), additionalInformation));
    }

    @Override
    public void check(StageExecution execution) {
        StringBuilder builder = new StringBuilder();
        SpectrumExecutionMonitor.printSpectrum(builder, execution, this.width, DetailLevel.IMPORTANT);
        long progress = Iterables.last(execution.steps()).stats().stat(Keys.done_batches).asLong() * (long)execution.getConfig().batchSize();
        long currentDelta = progress - this.lastProgress;
        builder.append(" \u2206").append(SpectrumExecutionMonitor.fitInProgress(currentDelta));
        this.lastProgress = progress;
        this.out.print("\r" + builder);
    }

    public static void printSpectrum(StringBuilder builder, StageExecution execution, int width, DetailLevel additionalStatsLevel) {
        long[] values2 = SpectrumExecutionMonitor.values(execution);
        long total2 = SpectrumExecutionMonitor.total(values2);
        Pair<Step<?>, Float> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        QuantizedProjection projection = new QuantizedProjection(total2, width -= 7);
        long lastDoneBatches = 0L;
        int stepIndex = 0;
        boolean hasProgressed = false;
        builder.append('[');
        for (Step<?> step : execution.steps()) {
            long stepWidth;
            StepStats stats = step.stats();
            if (!projection.next(values2[stepIndex])) break;
            long l = stepWidth = total2 == 0L && stepIndex == 0 ? (long)width : projection.step();
            if (stepWidth > 0L) {
                if (hasProgressed) {
                    --stepWidth;
                    builder.append('|');
                }
                boolean isBottleNeck = bottleNeck.first() == step;
                String name = (isBottleNeck ? "*" : "") + stats.toString(additionalStatsLevel) + (step.processors(0) > 1 ? "(" + step.processors(0) + ")" : "");
                int charIndex = 0;
                char backgroundChar = step.processors(0) > 1 ? (char)'=' : '-';
                int i = 0;
                while ((long)i < stepWidth) {
                    char ch = backgroundChar;
                    if (charIndex >= 0 && charIndex < name.length() && (long)charIndex < stepWidth) {
                        ch = name.charAt(charIndex);
                    }
                    builder.append(ch);
                    ++i;
                    ++charIndex;
                }
                hasProgressed = true;
            }
            lastDoneBatches = stats.stat(Keys.done_batches).asLong();
            ++stepIndex;
        }
        long progress = lastDoneBatches * (long)execution.getConfig().batchSize();
        builder.append("]").append(SpectrumExecutionMonitor.fitInProgress(progress));
    }

    private static String fitInProgress(long value2) {
        String progress;
        int weight = SpectrumExecutionMonitor.weight(value2);
        if (weight == 0) {
            progress = String.valueOf(value2);
        } else {
            double floatValue = (double)value2 / Math.pow(1000.0, weight);
            progress = String.valueOf(floatValue);
            if (progress.length() > 4) {
                progress = progress.substring(0, 4);
            }
            if (progress.endsWith(".")) {
                progress = progress.substring(0, progress.length() - 1);
            }
            progress = progress + WEIGHTS[weight];
        }
        return SpectrumExecutionMonitor.pad(progress, 5, ' ');
    }

    private static String pad(String result2, int length2, char padChar) {
        while (result2.length() < length2) {
            result2 = padChar + result2;
        }
        return result2;
    }

    private static int weight(long value2) {
        int weight = 0;
        while (value2 >= 1000L) {
            value2 /= 1000L;
            ++weight;
        }
        return weight;
    }

    private static long[] values(StageExecution execution) {
        long[] values2 = new long[execution.size()];
        int i = 0;
        for (Step<?> step : execution.steps()) {
            values2[i++] = SpectrumExecutionMonitor.avg(step.stats());
        }
        return values2;
    }

    private static long total(long[] values2) {
        long total2 = 0L;
        for (long value2 : values2) {
            total2 += value2;
        }
        return total2;
    }

    private static long avg(StatsProvider step) {
        return step.stat(Keys.avg_processing_time).asLong();
    }
}

