/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.stats;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class GenericStatsProvider
implements StatsProvider {
    private final Collection<Pair<Key, Stat>> stats = new ArrayList<Pair<Key, Stat>>();

    public void add(Key key, Stat stat) {
        this.stats.add(Pair.of(key, stat));
    }

    @Override
    public Stat stat(Key key) {
        for (Pair<Key, Stat> stat1 : this.stats) {
            if (!stat1.first().name().equals(key.name())) continue;
            return stat1.other();
        }
        return null;
    }

    @Override
    public Key[] keys() {
        Key[] keys = new Key[this.stats.size()];
        int i = 0;
        for (Pair<Key, Stat> stat : this.stats) {
            keys[i++] = stat.first();
        }
        return keys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Pair<Key, Stat> stat : this.stats) {
            builder.append(builder.length() > 0 ? ", " : "").append(String.format("%s: %s", stat.first().shortName(), stat.other()));
        }
        return builder.toString();
    }
}

