/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class ByteArray
extends IntegralArray {
    private final byte[] value;

    ByteArray(byte[] value2) {
        assert (value2 != null);
        this.value = value2;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public long longValue(int index) {
        return this.value[index];
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapByteArray(this);
    }

    @Override
    public boolean equals(Value other2) {
        return other2.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeByteArray(this.value);
    }

    public byte[] asObjectCopy() {
        return (byte[])this.value.clone();
    }

    @Deprecated
    public byte[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.byteValue(this.value[offset]);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "ByteArray";
    }
}

