/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public abstract class CRSCalculator {
    public abstract double distance(PointValue var1, PointValue var2);

    public abstract List<Pair<PointValue, PointValue>> boundingBox(PointValue var1, double var2);

    protected static double pythagoras(double[] a, double[] b) {
        double sqrSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff2 = a[i] - b[i];
            sqrSum += diff2 * diff2;
        }
        return Math.sqrt(sqrSum);
    }

    public static class GeographicCalculator
    extends CRSCalculator {
        public static final double EARTH_RADIUS_METERS = 6378140.0;
        private static final double EXTENSION_FACTOR = 1.0001;
        int dimension;

        GeographicCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] c1Coord = p1.coordinate();
            double[] c2Coord = p2.coordinate();
            double[] c1 = new double[]{Math.toRadians(c1Coord[0]), Math.toRadians(c1Coord[1])};
            double[] c2 = new double[]{Math.toRadians(c2Coord[0]), Math.toRadians(c2Coord[1])};
            double dx = c2[0] - c1[0];
            double dy = c2[1] - c1[1];
            double alpha = Math.pow(Math.sin(dy / 2.0), 2.0) + Math.cos(c1[1]) * Math.cos(c2[1]) * Math.pow(Math.sin(dx / 2.0), 2.0);
            double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(alpha), Math.sqrt(1.0 - alpha));
            if (this.dimension == 2) {
                return 6378140.0 * greatCircleDistance;
            }
            if (this.dimension == 3) {
                double avgHeight = (p1.coordinate()[2] + p2.coordinate()[2]) / 2.0;
                double distance2D = (6378140.0 + avgHeight) * greatCircleDistance;
                double[] a = new double[this.dimension - 1];
                double[] b = new double[this.dimension - 1];
                a[0] = distance2D;
                b[0] = 0.0;
                for (int i = 1; i < this.dimension - 1; ++i) {
                    a[i] = 0.0;
                    b[i] = c1Coord[i + 1] - c2Coord[i + 1];
                }
                return GeographicCalculator.pythagoras(a, b);
            }
            throw new UnsupportedOperationException("More than 3 dimensions are not supported for distance calculations.");
        }

        @Override
        public List<Pair<PointValue, PointValue>> boundingBox(PointValue center, double distance) {
            if (distance == 0.0) {
                return Collections.singletonList(Pair.of(center, center));
            }
            double extendedDistance = distance * 1.0001;
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            double lat = center.coordinate()[1];
            double lon = center.coordinate()[0];
            double r = extendedDistance / 6378140.0;
            double latMin = lat - Math.toDegrees(r);
            double latMax = lat + Math.toDegrees(r);
            if (latMax >= 90.0) {
                return Collections.singletonList(this.boundingBoxOf(-180.0, 180.0, latMin, 90.0, center, distance));
            }
            if (latMin <= -90.0) {
                return Collections.singletonList(this.boundingBoxOf(-180.0, 180.0, -90.0, latMax, center, distance));
            }
            double deltaLon = Math.toDegrees(Math.asin(Math.sin(r) / Math.cos(Math.toRadians(lat))));
            double lonMin = lon - deltaLon;
            double lonMax = lon + deltaLon;
            if (lonMin < -180.0 && lonMax > 180.0) {
                return Collections.singletonList(this.boundingBoxOf(-180.0, 180.0, latMin, latMax, center, distance));
            }
            if (lonMin < -180.0) {
                Pair<PointValue, PointValue> box1 = this.boundingBoxOf(lonMin + 360.0, 180.0, latMin, latMax, center, distance);
                Pair<PointValue, PointValue> box2 = this.boundingBoxOf(-180.0, lonMax, latMin, latMax, center, distance);
                return Arrays.asList(box1, box2);
            }
            if (lonMax > 180.0) {
                Pair<PointValue, PointValue> box1 = this.boundingBoxOf(lonMin, 180.0, latMin, latMax, center, distance);
                Pair<PointValue, PointValue> box2 = this.boundingBoxOf(-180.0, lonMax - 360.0, latMin, latMax, center, distance);
                return Arrays.asList(box1, box2);
            }
            return Collections.singletonList(this.boundingBoxOf(lonMin, lonMax, latMin, latMax, center, distance));
        }

        private Pair<PointValue, PointValue> boundingBoxOf(double minLon, double maxLon, double minLat, double maxLat, PointValue center, double distance) {
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            int dimension = center.getCoordinateReferenceSystem().getDimension();
            double[] min2 = new double[dimension];
            double[] max2 = new double[dimension];
            min2[0] = minLon;
            min2[1] = minLat;
            max2[0] = maxLon;
            max2[1] = maxLat;
            if (dimension > 2) {
                double[] coordinates = center.coordinate();
                for (int i = 2; i < dimension; ++i) {
                    min2[i] = coordinates[i] - distance;
                    max2[i] = coordinates[i] + distance;
                }
            }
            return Pair.of(Values.pointValue(crs, min2), Values.pointValue(crs, max2));
        }
    }

    public static class CartesianCalculator
    extends CRSCalculator {
        int dimension;

        CartesianCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            return CartesianCalculator.pythagoras(p1.coordinate(), p2.coordinate());
        }

        @Override
        public List<Pair<PointValue, PointValue>> boundingBox(PointValue center, double distance) {
            assert (center.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] coordinates = center.coordinate();
            double[] min2 = new double[this.dimension];
            double[] max2 = new double[this.dimension];
            for (int i = 0; i < this.dimension; ++i) {
                min2[i] = coordinates[i] - distance;
                max2[i] = coordinates[i] + distance;
            }
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            return Collections.singletonList(Pair.of(Values.pointValue(crs, min2), Values.pointValue(crs, max2)));
        }
    }
}

