/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.TemporalArithmeticException;
import org.neo4j.values.utils.TemporalParseException;
import org.neo4j.values.utils.UnsupportedTemporalUnitException;
import org.neo4j.values.virtual.MapValue;

public abstract class TemporalValue<T extends Temporal, V extends TemporalValue<T, V>>
extends ScalarValue
implements Temporal {
    TemporalValue() {
    }

    public abstract TemporalValue add(DurationValue var1);

    public abstract TemporalValue sub(DurationValue var1);

    abstract T temporal();

    abstract LocalDate getDatePart();

    abstract LocalTime getLocalTimePart();

    abstract OffsetTime getTimePart(Supplier<ZoneId> var1);

    abstract ZoneId getZoneId(Supplier<ZoneId> var1);

    abstract ZoneId getZoneId();

    abstract ZoneOffset getZoneOffset();

    abstract boolean supportsTimeZone();

    abstract boolean hasTime();

    abstract V replacement(T var1);

    public final T asObjectCopy() {
        return this.temporal();
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return hashFunction.update(hash, this.hashCode());
    }

    public final V with(TemporalAdjuster adjuster) {
        return this.replacement(this.temporal().with(adjuster));
    }

    public final V plus(TemporalAmount amount) {
        return this.replacement(this.temporal().plus(amount));
    }

    public final V minus(TemporalAmount amount) {
        return this.replacement(this.temporal().minus(amount));
    }

    public final V minus(long amountToSubtract, TemporalUnit unit) {
        return this.replacement(this.temporal().minus(amountToSubtract, unit));
    }

    @Override
    public final boolean isSupported(TemporalUnit unit) {
        return this.temporal().isSupported(unit);
    }

    public final V with(TemporalField field2, long newValue) {
        return this.replacement(this.temporal().with(field2, newValue));
    }

    public final V plus(long amountToAdd, TemporalUnit unit) {
        return this.replacement(this.temporal().plus(amountToAdd, unit));
    }

    @Override
    public final long until(Temporal endExclusive, TemporalUnit unit) {
        long until2;
        if (!(endExclusive instanceof TemporalValue)) {
            throw new InvalidValuesArgumentException("Can only compute durations between TemporalValues.");
        }
        TemporalValue from2 = this;
        TemporalValue to2 = (TemporalValue)endExclusive;
        from2 = this.attachTime(from2);
        to2 = this.attachTime(to2);
        if (from2.isSupported(ChronoField.MONTH_OF_YEAR) && !to2.isSupported(ChronoField.MONTH_OF_YEAR)) {
            to2 = this.attachDate(to2, from2.getDatePart());
        } else if (to2.isSupported(ChronoField.MONTH_OF_YEAR) && !from2.isSupported(ChronoField.MONTH_OF_YEAR)) {
            from2 = this.attachDate(from2, to2.getDatePart());
        }
        if (from2.supportsTimeZone() && !to2.supportsTimeZone()) {
            to2 = this.attachTimeZone(to2, from2.getZoneId(from2::getZoneOffset));
        } else if (to2.supportsTimeZone() && !from2.supportsTimeZone()) {
            from2 = this.attachTimeZone(from2, to2.getZoneId(to2::getZoneOffset));
        }
        try {
            until2 = from2.temporal().until(to2, unit);
        }
        catch (UnsupportedTemporalTypeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
        return until2;
    }

    private TemporalValue attachTime(TemporalValue temporal) {
        boolean supportsTime = temporal.isSupported(ChronoField.SECOND_OF_DAY);
        if (supportsTime) {
            return temporal;
        }
        LocalDate datePart = temporal.getDatePart();
        LocalTime timePart = LocalTimeValue.DEFAULT_LOCAL_TIME;
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(datePart, timePart));
    }

    private TemporalValue attachDate(TemporalValue temporal, LocalDate dateToAttach) {
        LocalTime timePart = temporal.getLocalTimePart();
        if (temporal.supportsTimeZone()) {
            return DateTimeValue.datetime(ZonedDateTime.of(dateToAttach, timePart, temporal.getZoneOffset()));
        }
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(dateToAttach, timePart));
    }

    private TemporalValue attachTimeZone(TemporalValue temporal, ZoneId zoneIdToAttach) {
        if (temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return DateTimeValue.datetime(ZonedDateTime.of(temporal.getDatePart(), temporal.getLocalTimePart(), zoneIdToAttach));
        }
        if (zoneIdToAttach instanceof ZoneOffset) {
            return TimeValue.time(OffsetTime.of(temporal.getLocalTimePart(), (ZoneOffset)zoneIdToAttach));
        }
        throw new IllegalStateException("Should only attach offsets to local times, not zone ids.");
    }

    @Override
    public final ValueRange range(TemporalField field2) {
        return this.temporal().range(field2);
    }

    @Override
    public final int get(TemporalField field2) {
        int accessor;
        try {
            accessor = this.temporal().get(field2);
        }
        catch (UnsupportedTemporalTypeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
        return accessor;
    }

    public final AnyValue get(String fieldName) {
        TemporalFields field2 = (TemporalFields)((Object)TemporalFields.fields.get(fieldName.toLowerCase()));
        if (field2 == TemporalFields.epochSeconds || field2 == TemporalFields.epochMillis) {
            T temp = this.temporal();
            if (temp instanceof ChronoZonedDateTime) {
                ChronoZonedDateTime zdt = (ChronoZonedDateTime)temp;
                if (field2 == TemporalFields.epochSeconds) {
                    return Values.longValue(zdt.toInstant().toEpochMilli() / 1000L);
                }
                return Values.longValue(zdt.toInstant().toEpochMilli());
            }
            throw new UnsupportedTemporalUnitException("Epoch not supported.");
        }
        if (field2 == TemporalFields.timezone) {
            return Values.stringValue(this.getZoneId(this::getZoneOffset).toString());
        }
        if (field2 == TemporalFields.offset) {
            return Values.stringValue(this.getZoneOffset().toString());
        }
        if (field2 == TemporalFields.offsetMinutes) {
            return Values.intValue(this.getZoneOffset().getTotalSeconds() / 60);
        }
        if (field2 == TemporalFields.offsetSeconds) {
            return Values.intValue(this.getZoneOffset().getTotalSeconds());
        }
        if (field2 == null || field2.field == null) {
            throw new UnsupportedTemporalUnitException("No such field: " + fieldName);
        }
        return Values.intValue(this.get(field2.field));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.temporal().query(query);
    }

    @Override
    public final boolean isSupported(TemporalField field2) {
        return this.temporal().isSupported(field2);
    }

    @Override
    public final long getLong(TemporalField field2) {
        return this.temporal().getLong(field2);
    }

    @Override
    public final NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(long x) {
        return false;
    }

    @Override
    public final boolean equals(double x) {
        return false;
    }

    @Override
    public final boolean equals(char x) {
        return false;
    }

    @Override
    public final boolean equals(String x) {
        return false;
    }

    public String toString() {
        return this.prettyPrint();
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, CharSequence text) {
        VALUE result2;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result2 = matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result2 == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.toString(), 0);
        }
        return result2;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, TextValue text) {
        VALUE result2;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result2 = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result2 == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result2;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, CharSequence text, Supplier<ZoneId> defaultZone) {
        VALUE result2;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result2 = matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result2 == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.toString(), 0);
        }
        return result2;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, TextValue text, Supplier<ZoneId> defaultZone) {
        VALUE result2;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result2 = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result2 == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result2;
    }

    private static <VALUE> String valueName(Class<VALUE> type) {
        String name = type.getSimpleName();
        return name.substring(0, name.length() - 5);
    }

    public static TimeCSVHeaderInformation parseHeaderInformation(String text) {
        TimeCSVHeaderInformation fields = new TimeCSVHeaderInformation();
        Value.parseHeaderInformation(text, "time/datetime", fields);
        return fields;
    }

    private static AnyValue assignment(TemporalFields field2, AnyValue oldValue, AnyValue newValue) {
        if (oldValue != null) {
            throw new InvalidValuesArgumentException("cannot re-assign " + (Object)((Object)field2));
        }
        return newValue;
    }

    @SafeVarargs
    static void assertDefinedInOrder(Pair<AnyValue, String> ... values2) {
        if (values2[0].first() == null) {
            throw new InvalidValuesArgumentException(values2[0].other() + " must be specified");
        }
        String firstNotAssigned = null;
        for (Pair<AnyValue, String> value2 : values2) {
            if (value2.first() == null) {
                if (firstNotAssigned != null) continue;
                firstNotAssigned = value2.other();
                continue;
            }
            if (firstNotAssigned == null) continue;
            throw new InvalidValuesArgumentException(value2.other() + " cannot be specified without " + firstNotAssigned);
        }
    }

    @SafeVarargs
    static void assertAllDefined(Pair<AnyValue, String> ... values2) {
        for (Pair<AnyValue, String> value2 : values2) {
            if (value2.first() != null) continue;
            throw new InvalidValuesArgumentException(value2.other() + " must be specified");
        }
    }

    static AnyValue oneOf(AnyValue a, AnyValue b, AnyValue c) {
        return a != null ? a : (b != null ? b : c);
    }

    static ZoneId timezoneOf(AnyValue timezone) {
        if (timezone instanceof TextValue) {
            return DateTimeValue.parseZoneName(((TextValue)timezone).stringValue());
        }
        throw new UnsupportedOperationException("Cannot convert to ZoneId: " + timezone);
    }

    static int validNano(AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
        long ms = IntegralValue.safeCastIntegral("millisecond", millisecond, TemporalFields.millisecond.defaultValue);
        long us = IntegralValue.safeCastIntegral("microsecond", microsecond, TemporalFields.microsecond.defaultValue);
        long ns = IntegralValue.safeCastIntegral("nanosecond", nanosecond, TemporalFields.nanosecond.defaultValue);
        if (ms < 0L || ms >= 1000L) {
            throw new InvalidValuesArgumentException("Invalid value for Millisecond: " + ms);
        }
        if (us < 0L || us >= (long)(millisecond != null ? 1000 : 1000000)) {
            throw new InvalidValuesArgumentException("Invalid value for Microsecond: " + us);
        }
        if (ns < 0L || ns >= (long)(microsecond != null ? 1000 : (millisecond != null ? 1000000 : 1000000000))) {
            throw new InvalidValuesArgumentException("Invalid value for Nanosecond: " + ns);
        }
        return (int)(ms * 1000000L + us * 1000L + ns);
    }

    static <TEMP extends Temporal, VALUE> VALUE updateFieldMapWithConflictingSubseconds(MapValue fields, TemporalUnit unit, TEMP temporal, BiFunction<MapValue, TEMP, VALUE> mapFunction) {
        boolean conflictingMicroSeconds;
        boolean conflictingMilliSeconds = unit == ChronoUnit.MILLIS && (fields.containsKey("microsecond") || fields.containsKey("nanosecond"));
        boolean bl = conflictingMicroSeconds = unit == ChronoUnit.MICROS && fields.containsKey("nanosecond");
        if (conflictingMilliSeconds) {
            IntValue millis = Values.intValue(temporal.get(ChronoField.MILLI_OF_SECOND));
            AnyValue micros = fields.get("microsecond");
            AnyValue nanos = fields.get("nanosecond");
            int newNanos = TemporalValue.validNano(millis, micros, nanos);
            Temporal newTemporal = temporal.with(ChronoField.NANO_OF_SECOND, newNanos);
            MapValue filtered2 = fields.filter((k, ignore) -> !k.equals("microsecond") && !k.equals("nanosecond"));
            return mapFunction.apply(filtered2, newTemporal);
        }
        if (conflictingMicroSeconds) {
            IntValue micros = Values.intValue(temporal.get(ChronoField.MICRO_OF_SECOND));
            AnyValue nanos = fields.get("nanosecond");
            int newNanos = TemporalValue.validNano(null, micros, nanos);
            Temporal newTemporal = temporal.with(ChronoField.NANO_OF_SECOND, newNanos);
            MapValue filtered3 = fields.filter((k, ignore) -> !k.equals("nanosecond"));
            return mapFunction.apply(filtered3, newTemporal);
        }
        return mapFunction.apply(fields, temporal);
    }

    static <TEMP extends Temporal> TEMP assertValidArgument(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertValidUnit(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
    }

    static <OFFSET extends ZoneId> OFFSET assertValidZone(Supplier<OFFSET> func) {
        try {
            return (OFFSET)((ZoneId)func.get());
        }
        catch (DateTimeException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertParsable(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new TemporalParseException(e.getMessage(), e);
        }
    }

    static String assertPrintable(Supplier<String> func) {
        try {
            return func.get();
        }
        catch (DateTimeException e) {
            throw new TemporalParseException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertValidArithmetic(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new TemporalArithmeticException(e.getMessage(), e);
        }
    }

    static Pair<LocalDate, LocalTime> getTruncatedDateAndTime(TemporalUnit unit, TemporalValue input2, String type) {
        LocalTime truncatedTime;
        LocalDate truncatedDate;
        LocalTime localTime;
        if (unit.isTimeBased() && !(input2 instanceof DateTimeValue) && !(input2 instanceof LocalDateTimeValue)) {
            throw new UnsupportedTemporalUnitException(String.format("Cannot truncate %s to %s with a time based unit.", input2, type));
        }
        LocalDate localDate = input2.getDatePart();
        LocalTime localTime2 = localTime = input2.hasTime() ? input2.getLocalTimePart() : LocalTimeValue.DEFAULT_LOCAL_TIME;
        if (unit.isDateBased()) {
            truncatedDate = DateValue.truncateTo(localDate, unit);
            truncatedTime = LocalTimeValue.DEFAULT_LOCAL_TIME;
        } else {
            truncatedDate = localDate;
            truncatedTime = localTime.truncatedTo(unit);
        }
        return Pair.of(truncatedDate, truncatedTime);
    }

    static class TimeCSVHeaderInformation
    implements CSVHeaderInformation {
        String timezone;

        TimeCSVHeaderInformation() {
        }

        @Override
        public void assign(String key, Object valueObj) {
            if (!(valueObj instanceof String)) {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", valueObj, key));
            }
            String value2 = (String)valueObj;
            if ("timezone".equals(key.toLowerCase())) {
                if (this.timezone != null) {
                    throw new InvalidValuesArgumentException("Cannot set timezone twice");
                }
            } else {
                throw new InvalidValuesArgumentException("Unsupported header field: " + value2);
            }
            this.timezone = value2;
        }

        Supplier<ZoneId> zoneSupplier(Supplier<ZoneId> defaultSupplier) {
            if (this.timezone != null) {
                ZoneId tz = DateTimeValue.parseZoneName(this.timezone);
                return () -> tz;
            }
            return defaultSupplier;
        }
    }

    private static final class OrdinalDate
    extends ConstructDate {
        private AnyValue ordinalDay;

        OrdinalDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case year: {
                    this.year = TemporalValue.assignment(field2, this.year, value2);
                    return this;
                }
                case ordinalDay: {
                    this.ordinalDay = TemporalValue.assignment(field2, this.ordinalDay, value2);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field2, this.date, value2);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field2) + " to ordinal date.");
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of(this.year, "year"), Pair.of(this.ordinalDay, "ordinalDay"));
            }
        }
    }

    private static final class QuarterDate
    extends ConstructDate {
        private AnyValue quarter;
        private AnyValue dayOfQuarter;

        QuarterDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case year: {
                    this.year = TemporalValue.assignment(field2, this.year, value2);
                    return this;
                }
                case quarter: {
                    this.quarter = TemporalValue.assignment(field2, this.quarter, value2);
                    return this;
                }
                case dayOfQuarter: {
                    this.dayOfQuarter = TemporalValue.assignment(field2, this.dayOfQuarter, value2);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field2, this.date, value2);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field2) + " to quarter date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of(this.year, "year"), Pair.of(this.quarter, "quarter"), Pair.of(this.dayOfQuarter, "dayOfQuarter"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of(this.year, "year"), Pair.of(this.quarter, "quarter"), Pair.of(this.dayOfQuarter, "dayOfQuarter"));
            }
        }
    }

    private static final class WeekDate
    extends ConstructDate {
        private AnyValue week;
        private AnyValue dayOfWeek;

        WeekDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case year: {
                    this.year = TemporalValue.assignment(field2, this.year, value2);
                    return this;
                }
                case week: {
                    this.week = TemporalValue.assignment(field2, this.week, value2);
                    return this;
                }
                case dayOfWeek: {
                    this.dayOfWeek = TemporalValue.assignment(field2, this.dayOfWeek, value2);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field2, this.date, value2);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field2) + " to week date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of(this.year, "year"), Pair.of(this.week, "week"), Pair.of(this.dayOfWeek, "dayOfWeek"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of(this.year, "year"), Pair.of(this.week, "week"), Pair.of(this.dayOfWeek, "dayOfWeek"));
            }
        }
    }

    private static final class CalendarDate
    extends ConstructDate {
        private AnyValue month;
        private AnyValue day;

        CalendarDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case year: {
                    this.year = TemporalValue.assignment(field2, this.year, value2);
                    return this;
                }
                case month: {
                    this.month = TemporalValue.assignment(field2, this.month, value2);
                    return this;
                }
                case day: {
                    this.day = TemporalValue.assignment(field2, this.day, value2);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field2, this.date, value2);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field2) + " to calendar date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of(this.year, "year"), Pair.of(this.month, "month"), Pair.of(this.day, "day"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of(this.year, "year"), Pair.of(this.month, "month"), Pair.of(this.day, "day"));
            }
        }
    }

    private static class ConstructDate
    extends DateBuilder {
        AnyValue year;
        AnyValue date;

        ConstructDate() {
        }

        ConstructDate(AnyValue date) {
            this.date = date;
        }

        @Override
        ConstructDate assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case year: {
                    this.year = TemporalValue.assignment(field2, this.year, value2);
                    return this;
                }
                case quarter: 
                case dayOfQuarter: {
                    return new QuarterDate(this.year, this.date).assign(field2, value2);
                }
                case month: 
                case day: {
                    return new CalendarDate(this.year, this.date).assign(field2, value2);
                }
                case week: 
                case dayOfWeek: {
                    return new WeekDate(this.year, this.date).assign(field2, value2);
                }
                case ordinalDay: {
                    return new OrdinalDate(this.year, this.date).assign(field2, value2);
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field2, this.date, value2);
                    return this;
                }
            }
            throw new IllegalStateException("Not a date field: " + (Object)((Object)field2));
        }

        @Override
        void checkAssignments() {
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                throw new InvalidValuesArgumentException(TemporalFields.month.name() + " must be specified");
            }
        }
    }

    private static final class ConstructTime {
        private AnyValue hour;
        private AnyValue minute;
        private AnyValue second;
        private AnyValue millisecond;
        private AnyValue microsecond;
        private AnyValue nanosecond;
        private AnyValue time;

        ConstructTime() {
        }

        void assign(TemporalFields field2, AnyValue value2) {
            switch (field2) {
                case hour: {
                    this.hour = TemporalValue.assignment(field2, this.hour, value2);
                    break;
                }
                case minute: {
                    this.minute = TemporalValue.assignment(field2, this.minute, value2);
                    break;
                }
                case second: {
                    this.second = TemporalValue.assignment(field2, this.second, value2);
                    break;
                }
                case millisecond: {
                    this.millisecond = TemporalValue.assignment(field2, this.millisecond, value2);
                    break;
                }
                case microsecond: {
                    this.microsecond = TemporalValue.assignment(field2, this.microsecond, value2);
                    break;
                }
                case nanosecond: {
                    this.nanosecond = TemporalValue.assignment(field2, this.nanosecond, value2);
                    break;
                }
                case time: 
                case datetime: {
                    this.time = TemporalValue.assignment(field2, this.time, value2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Not a time field: " + (Object)((Object)field2));
                }
            }
        }

        void checkAssignments() {
            if (this.time == null) {
                TemporalValue.assertDefinedInOrder(Pair.of(this.hour, "hour"), Pair.of(this.minute, "minute"), Pair.of(this.second, "second"), Pair.of(TemporalValue.oneOf(this.millisecond, this.microsecond, this.nanosecond), "subsecond"));
            }
        }
    }

    private static abstract class DateBuilder {
        private DateBuilder() {
        }

        abstract DateBuilder assign(TemporalFields var1, AnyValue var2);

        abstract void checkAssignments();

        abstract void assertFullyAssigned();
    }

    private static class SelectDateOrTimeDTBuilder
    extends DateTimeBuilder {
        SelectDateOrTimeDTBuilder(DateBuilder date, ConstructTime time) {
            super(date, time);
        }

        @Override
        DateTimeBuilder assign(TemporalFields field2, AnyValue value2) {
            if (field2 == TemporalFields.datetime || field2 == TemporalFields.epochSeconds || field2 == TemporalFields.epochMillis) {
                throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with date or time.");
            }
            return this.assignToSubBuilders(field2, value2);
        }
    }

    private static class SelectDateTimeDTBuilder
    extends DateTimeBuilder {
        private AnyValue datetime;
        private AnyValue epochSeconds;
        private AnyValue epochMillis;

        SelectDateTimeDTBuilder(DateBuilder date, ConstructTime time) {
            super(date, time);
        }

        @Override
        void checkAssignments(boolean requiresDate) {
        }

        @Override
        DateTimeBuilder assign(TemporalFields field2, AnyValue value2) {
            if (field2 == TemporalFields.date || field2 == TemporalFields.time) {
                throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with datetime or epochSeconds or epochMillis.");
            }
            if (field2 == TemporalFields.datetime) {
                if (this.epochSeconds != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with epochSeconds.");
                }
                if (this.epochMillis != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with epochMillis.");
                }
                this.datetime = TemporalValue.assignment(TemporalFields.datetime, this.datetime, value2);
            } else if (field2 == TemporalFields.epochSeconds) {
                if (this.epochMillis != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with epochMillis.");
                }
                if (this.datetime != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with datetime.");
                }
                this.epochSeconds = TemporalValue.assignment(TemporalFields.epochSeconds, this.epochSeconds, value2);
            } else if (field2 == TemporalFields.epochMillis) {
                if (this.epochSeconds != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with epochSeconds.");
                }
                if (this.datetime != null) {
                    throw new InvalidValuesArgumentException(field2.name() + " cannot be selected together with datetime.");
                }
                this.epochMillis = TemporalValue.assignment(TemporalFields.epochMillis, this.epochMillis, value2);
            } else {
                return this.assignToSubBuilders(field2, value2);
            }
            return this;
        }
    }

    private static class DateTimeBuilder {
        protected DateBuilder date;
        protected ConstructTime time;

        DateTimeBuilder() {
        }

        DateTimeBuilder(DateBuilder date, ConstructTime time) {
            this.date = date;
            this.time = time;
        }

        void checkAssignments(boolean requiresDate) {
            if (this.date != null) {
                this.date.checkAssignments();
            }
            if (this.time != null) {
                if (requiresDate) {
                    if (this.date != null) {
                        this.date.assertFullyAssigned();
                    } else {
                        throw new InvalidValuesArgumentException(TemporalFields.year.name() + " must be specified");
                    }
                }
                this.time.checkAssignments();
            }
        }

        DateTimeBuilder assign(TemporalFields field2, AnyValue value2) {
            if (field2 == TemporalFields.datetime || field2 == TemporalFields.epochSeconds || field2 == TemporalFields.epochMillis) {
                return new SelectDateTimeDTBuilder(this.date, this.time).assign(field2, value2);
            }
            if (field2 == TemporalFields.time || field2 == TemporalFields.date) {
                return new SelectDateOrTimeDTBuilder(this.date, this.time).assign(field2, value2);
            }
            return this.assignToSubBuilders(field2, value2);
        }

        DateTimeBuilder assignToSubBuilders(TemporalFields field2, AnyValue value2) {
            if (field2 == TemporalFields.date || field2.field != null && field2.field.isDateBased()) {
                if (this.date == null) {
                    this.date = new ConstructDate();
                }
                this.date = this.date.assign(field2, value2);
            } else if (field2 == TemporalFields.time || field2.field != null && field2.field.isTimeBased()) {
                if (this.time == null) {
                    this.time = new ConstructTime();
                }
                this.time.assign(field2, value2);
            } else {
                throw new IllegalStateException("This method should not be used for any fields the DateBuilder or TimeBuilder can't handle");
            }
            return this;
        }
    }

    public static class TemporalFields
    extends Enum<TemporalFields> {
        public static final /* enum */ TemporalFields year = new TemporalFields(ChronoField.YEAR, 0);
        public static final /* enum */ TemporalFields quarter = new TemporalFields(IsoFields.QUARTER_OF_YEAR, 1);
        public static final /* enum */ TemporalFields month = new TemporalFields(ChronoField.MONTH_OF_YEAR, 1);
        public static final /* enum */ TemporalFields week = new TemporalFields(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1);
        public static final /* enum */ TemporalFields ordinalDay = new TemporalFields(ChronoField.DAY_OF_YEAR, 1);
        public static final /* enum */ TemporalFields dayOfQuarter = new TemporalFields(IsoFields.DAY_OF_QUARTER, 1);
        public static final /* enum */ TemporalFields dayOfWeek = new TemporalFields(ChronoField.DAY_OF_WEEK, 1);
        public static final /* enum */ TemporalFields day = new TemporalFields(ChronoField.DAY_OF_MONTH, 1);
        public static final /* enum */ TemporalFields hour = new TemporalFields(ChronoField.HOUR_OF_DAY, 0);
        public static final /* enum */ TemporalFields minute = new TemporalFields(ChronoField.MINUTE_OF_HOUR, 0);
        public static final /* enum */ TemporalFields second = new TemporalFields(ChronoField.SECOND_OF_MINUTE, 0);
        public static final /* enum */ TemporalFields millisecond = new TemporalFields(ChronoField.MILLI_OF_SECOND, 0);
        public static final /* enum */ TemporalFields microsecond = new TemporalFields(ChronoField.MICRO_OF_SECOND, 0);
        public static final /* enum */ TemporalFields nanosecond = new TemporalFields(ChronoField.NANO_OF_SECOND, 0);
        public static final /* enum */ TemporalFields weekYear = new TemporalFields(IsoFields.WEEK_BASED_YEAR, 0){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ TemporalFields offset = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ TemporalFields offsetMinutes = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ TemporalFields offsetSeconds = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ TemporalFields timezone = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsTimeZone()) {
                    throw new UnsupportedTemporalUnitException("Cannot assign time zone if also assigning other fields.");
                }
                if (builder.timezone != null) {
                    throw new InvalidValuesArgumentException("Cannot assign timezone twice.");
                }
                builder.timezone = value2;
            }
        };
        public static final /* enum */ TemporalFields date = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsDate()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ TemporalFields time = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsTime()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ TemporalFields datetime = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsDate() || !builder.supportsTime()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ TemporalFields epochSeconds = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsEpoch()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ TemporalFields epochMillis = new TemporalFields(){

            @Override
            void assign(Builder<?> builder, AnyValue value2) {
                if (!builder.supportsEpoch()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        private static final Map<String, TemporalFields> fields;
        final TemporalField field;
        final int defaultValue;
        private static final /* synthetic */ TemporalFields[] $VALUES;

        public static TemporalFields[] values() {
            return (TemporalFields[])$VALUES.clone();
        }

        public static TemporalFields valueOf(String name) {
            return Enum.valueOf(TemporalFields.class, name);
        }

        private TemporalFields(TemporalField field2, int defaultValue) {
            this.field = field2;
            this.defaultValue = defaultValue;
        }

        private TemporalFields() {
            this.field = null;
            this.defaultValue = -1;
        }

        boolean isGroupSelector() {
            return false;
        }

        void assign(Builder<?> builder, AnyValue value2) {
            assert (this.field != null) : "method should have been overridden";
            if (!((Builder)builder).supports(this.field)) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
            if (((Builder)builder).state == null) {
                ((Builder)builder).state = new DateTimeBuilder();
            }
            ((Builder)builder).state = ((Builder)builder).state.assign(this, value2);
        }

        public static Set<String> allFields() {
            return fields.keySet();
        }

        static {
            $VALUES = new TemporalFields[]{year, quarter, month, week, ordinalDay, dayOfQuarter, dayOfWeek, day, hour, minute, second, millisecond, microsecond, nanosecond, weekYear, offset, offsetMinutes, offsetSeconds, timezone, date, time, datetime, epochSeconds, epochMillis};
            fields = new HashMap<String, TemporalFields>();
            for (TemporalFields field2 : TemporalFields.values()) {
                fields.put(field2.name().toLowerCase(), field2);
            }
            fields.put("weekday", dayOfWeek);
            fields.put("quarterday", dayOfQuarter);
        }
    }

    static abstract class Builder<Result>
    implements StructureBuilder<AnyValue, Result> {
        private final Supplier<ZoneId> defaultZone;
        private DateTimeBuilder state;
        protected AnyValue timezone;
        protected Map<TemporalFields, AnyValue> fields = new EnumMap<TemporalFields, AnyValue>(TemporalFields.class);

        Builder(Supplier<ZoneId> defaultZone) {
            this.defaultZone = defaultZone;
        }

        @Override
        public final Result build() {
            if (this.state == null) {
                throw new InvalidValuesArgumentException("Builder state empty");
            }
            this.state.checkAssignments(this.supportsDate());
            try {
                return this.buildInternal();
            }
            catch (DateTimeException e) {
                throw new InvalidValuesArgumentException(e.getMessage(), e);
            }
        }

        <Temp extends Temporal> Temp assignAllFields(Temp temp) {
            Object result2 = temp;
            for (Map.Entry<TemporalFields, AnyValue> entry : this.fields.entrySet()) {
                TemporalFields f = entry.getKey();
                if (f == TemporalFields.year && this.fields.containsKey((Object)TemporalFields.week)) {
                    result2 = result2.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(f.name(), entry.getValue(), f.defaultValue));
                    continue;
                }
                if (f.isGroupSelector() || f == TemporalFields.timezone || f == TemporalFields.millisecond || f == TemporalFields.microsecond || f == TemporalFields.nanosecond) continue;
                TemporalField temporalField = f.field;
                result2 = result2.with(temporalField, IntegralValue.safeCastIntegral(f.name(), entry.getValue(), f.defaultValue));
            }
            if (this.supportsTime() && (this.fields.containsKey((Object)TemporalFields.millisecond) || this.fields.containsKey((Object)TemporalFields.microsecond) || this.fields.containsKey((Object)TemporalFields.nanosecond))) {
                result2 = result2.with(TemporalFields.nanosecond.field, TemporalValue.validNano(this.fields.get((Object)TemporalFields.millisecond), this.fields.get((Object)TemporalFields.microsecond), this.fields.get((Object)TemporalFields.nanosecond)));
            }
            return result2;
        }

        @Override
        public final StructureBuilder<AnyValue, Result> add(String fieldName, AnyValue value2) {
            TemporalFields field2 = (TemporalFields)((Object)TemporalFields.fields.get(fieldName.toLowerCase()));
            if (field2 == null) {
                throw new InvalidValuesArgumentException("No such field: " + fieldName);
            }
            field2.assign(this, value2);
            this.fields.put(field2, value2);
            return this;
        }

        private boolean supports(TemporalField field2) {
            if (field2.isDateBased()) {
                return this.supportsDate();
            }
            if (field2.isTimeBased()) {
                return this.supportsTime();
            }
            throw new IllegalStateException("Fields should be either date based or time based");
        }

        protected abstract boolean supportsDate();

        protected abstract boolean supportsTime();

        protected abstract boolean supportsTimeZone();

        protected abstract boolean supportsEpoch();

        protected ZoneId timezone(AnyValue timezone) {
            return timezone == null ? this.defaultZone.get() : TemporalValue.timezoneOf(timezone);
        }

        protected abstract Result buildInternal();

        protected final ZoneId optionalTimezone() {
            return this.timezone == null ? null : this.timezone();
        }

        protected final ZoneId timezone() {
            return this.timezone(this.timezone);
        }
    }
}

