/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public interface ValueWriter<E extends Exception> {
    public void writeNull() throws E;

    public void writeBoolean(boolean var1) throws E;

    public void writeInteger(byte var1) throws E;

    public void writeInteger(short var1) throws E;

    public void writeInteger(int var1) throws E;

    public void writeInteger(long var1) throws E;

    public void writeFloatingPoint(float var1) throws E;

    public void writeFloatingPoint(double var1) throws E;

    public void writeString(String var1) throws E;

    public void writeString(char var1) throws E;

    default public void writeUTF8(byte[] bytes2, int offset, int length2) throws E {
        this.writeString(new String(bytes2, offset, length2, StandardCharsets.UTF_8));
    }

    public void beginArray(int var1, ArrayType var2) throws E;

    public void endArray() throws E;

    public void writeByteArray(byte[] var1) throws E;

    public void writePoint(CoordinateReferenceSystem var1, double[] var2) throws E;

    public void writeDuration(long var1, long var3, long var5, int var7) throws E;

    public void writeDate(LocalDate var1) throws E;

    public void writeLocalTime(LocalTime var1) throws E;

    public void writeTime(OffsetTime var1) throws E;

    public void writeLocalDateTime(LocalDateTime var1) throws E;

    public void writeDateTime(ZonedDateTime var1) throws E;

    public static class Adapter<E extends Exception>
    implements ValueWriter<E> {
        @Override
        public void writeNull() throws E {
        }

        @Override
        public void writeBoolean(boolean value2) throws E {
        }

        @Override
        public void writeInteger(byte value2) throws E {
        }

        @Override
        public void writeInteger(short value2) throws E {
        }

        @Override
        public void writeInteger(int value2) throws E {
        }

        @Override
        public void writeInteger(long value2) throws E {
        }

        @Override
        public void writeFloatingPoint(float value2) throws E {
        }

        @Override
        public void writeFloatingPoint(double value2) throws E {
        }

        @Override
        public void writeString(String value2) throws E {
        }

        @Override
        public void writeString(char value2) throws E {
        }

        @Override
        public void beginArray(int size2, ArrayType arrayType) throws E {
        }

        @Override
        public void endArray() throws E {
        }

        @Override
        public void writeByteArray(byte[] value2) throws E {
        }

        @Override
        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws E {
        }

        @Override
        public void writeDuration(long months, long days, long seconds, int nanos) {
        }

        @Override
        public void writeDate(LocalDate localDate) throws E {
        }

        @Override
        public void writeLocalTime(LocalTime localTime) throws E {
        }

        @Override
        public void writeTime(OffsetTime offsetTime) throws E {
        }

        @Override
        public void writeLocalDateTime(LocalDateTime localDateTime) throws E {
        }

        @Override
        public void writeDateTime(ZonedDateTime zonedDateTime) throws E {
        }
    }

    public static enum ArrayType {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        CHAR,
        POINT,
        ZONED_DATE_TIME,
        LOCAL_DATE_TIME,
        DATE,
        ZONED_TIME,
        LOCAL_TIME,
        DURATION;

    }
}

