/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public interface FileMoveAction {
    public void move(File var1, CopyOption ... var2) throws IOException;

    public File file();

    public static FileMoveAction copyViaFileSystem(final File file, File basePath) {
        final Path base = basePath.toPath();
        return new FileMoveAction(){

            @Override
            public void move(File toDir, CopyOption ... copyOptions) throws IOException {
                Path originalPath = file.toPath();
                Path relativePath = base.relativize(originalPath);
                Path resolvedPath = toDir.toPath().resolve(relativePath);
                if (!Files.isSymbolicLink(resolvedPath.getParent())) {
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(originalPath, resolvedPath, copyOptions);
            }

            @Override
            public File file() {
                return file;
            }
        };
    }

    public static FileMoveAction moveViaFileSystem(final File sourceFile, final File sourceDirectory) {
        return new FileMoveAction(){

            @Override
            public void move(File toDir, CopyOption ... copyOptions) throws IOException {
                FileMoveAction.copyViaFileSystem(sourceFile, sourceDirectory).move(toDir, copyOptions);
                if (!sourceFile.delete()) {
                    throw new IOException("Unable to delete source file after copying " + sourceFile);
                }
            }

            @Override
            public File file() {
                return sourceFile;
            }
        };
    }
}

