/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.FileMoveProvider;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToFileStoreWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.WritableChannel;

public class StoreCopyClient {
    private final DatabaseLayout databaseLayout;
    private final Config config;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final Log log;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final StoreCopyClientMonitor monitor;
    private final boolean forensics;
    private final FileMoveProvider fileMoveProvider;

    public StoreCopyClient(DatabaseLayout databaseLayout, Config config, Iterable<KernelExtensionFactory<?>> kernelExtensions, LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, StoreCopyClientMonitor monitor, boolean forensics) {
        this(databaseLayout, config, kernelExtensions, logProvider, fs, pageCache, monitor, forensics, new FileMoveProvider(fs));
    }

    public StoreCopyClient(DatabaseLayout databaseLayout, Config config, Iterable<KernelExtensionFactory<?>> kernelExtensions, LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, StoreCopyClientMonitor monitor, boolean forensics, FileMoveProvider fileMoveProvider) {
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.kernelExtensions = kernelExtensions;
        this.log = logProvider.getLog(this.getClass());
        this.fs = fs;
        this.pageCache = pageCache;
        this.monitor = monitor;
        this.forensics = forensics;
        this.fileMoveProvider = fileMoveProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStore(StoreCopyRequester requester, CancellationRequest cancellationRequest, MoveAfterCopy moveAfterCopy) throws Exception {
        this.monitor.start();
        File tempDatabaseDirectory = this.databaseLayout.file("temp-copy");
        try {
            StoreCopyClient.cleanDirectory(tempDatabaseDirectory);
            this.monitor.startReceivingStoreFiles();
            ToFileStoreWriter storeWriter = new ToFileStoreWriter(tempDatabaseDirectory, this.fs, this.monitor);
            try (Response<?> response = requester.copyStore(this.decorateWithProgressIndicator(storeWriter));){
                this.monitor.finishReceivingStoreFiles();
                this.writeTransactionsToActiveLogFile(DatabaseLayout.of((File)tempDatabaseDirectory), response);
            }
            finally {
                requester.done();
            }
            this.checkCancellation(cancellationRequest, tempDatabaseDirectory);
            this.recoverDatabase(tempDatabaseDirectory);
            this.moveFromTemporaryLocationToCorrect(tempDatabaseDirectory, moveAfterCopy);
            this.monitor.finish();
        }
        finally {
            FileUtils.deleteRecursively((File)tempDatabaseDirectory);
        }
    }

    private void moveFromTemporaryLocationToCorrect(File tempStore, MoveAfterCopy moveAfterCopy) throws Exception {
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withConfig(this.config).build();
        Stream<FileMoveAction> moveActionStream = this.fileMoveProvider.traverseForMoving(tempStore);
        Function<File, File> destinationMapper = file -> logFiles.isLogFile(file) ? logFiles.logFilesDirectory() : this.databaseLayout.databaseDirectory();
        moveAfterCopy.move(moveActionStream, tempStore, destinationMapper);
    }

    private void recoverDatabase(File tempStore) {
        this.monitor.startRecoveringStore();
        File storeDir = tempStore.getParentFile();
        GraphDatabaseService graphDatabaseService = this.newTempDatabase(tempStore);
        graphDatabaseService.shutdown();
        File lockFile = StoreLayout.of((File)storeDir).storeLockFile();
        if (lockFile.exists()) {
            FileUtils.deleteFile((File)lockFile);
        }
        this.monitor.finishRecoveringStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransactionsToActiveLogFile(DatabaseLayout databaseLayout, Response<?> response) throws Exception {
        LifeSupport life = new LifeSupport();
        try {
            LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).build();
            life.add((Lifecycle)logFiles);
            life.start();
            FlushablePositionAwareChannel channel = logFiles.getLogFile().getWriter();
            final TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((WritableChannel)channel));
            final AtomicLong firstTxId = new AtomicLong(1L);
            response.accept(new Response.Handler(){

                @Override
                public void obligation(long txId) {
                    throw new UnsupportedOperationException("Shouldn't be called");
                }

                @Override
                public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
                    return transaction -> {
                        long txId = transaction.getCommitEntry().getTxId();
                        if (firstTxId.compareAndSet(1L, txId)) {
                            StoreCopyClient.this.monitor.startReceivingTransactions(txId);
                        }
                        writer.append(transaction.getTransactionRepresentation(), txId);
                        return false;
                    };
                }
            });
            long endTxId = firstTxId.get();
            if (endTxId != 1L) {
                this.monitor.finishReceivingTransactions(endTxId);
            }
            long currentLogVersion = logFiles.getHighestLogVersion();
            writer.checkPoint(new LogPosition(currentLogVersion, 16L));
            File currentLogFile = logFiles.getLogFileForVersion(currentLogVersion);
            LogHeaderWriter.writeLogHeader((FileSystemAbstraction)this.fs, (File)currentLogFile, (long)currentLogVersion, (long)Math.max(1L, endTxId - 1L));
            if (!this.forensics) {
                File neoStore = databaseLayout.metadataStore();
                MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, (long)16L);
            }
        }
        finally {
            life.shutdown();
        }
    }

    private GraphDatabaseService newTempDatabase(File tempStore) {
        ExternallyManagedPageCache.GraphDatabaseFactoryWithPageCacheFactory factory = ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache(this.pageCache);
        return factory.setKernelExtensions(this.kernelExtensions).setUserLogProvider((LogProvider)NullLogProvider.getInstance()).newEmbeddedDatabaseBuilder(tempStore.getAbsoluteFile()).setConfig(GraphDatabaseSettings.active_database, tempStore.getName()).setConfig("dbms.backup.enabled", "false").setConfig(GraphDatabaseSettings.pagecache_warmup_enabled, "false").setConfig(GraphDatabaseSettings.logs_directory, tempStore.getAbsolutePath()).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").setConfig(GraphDatabaseSettings.logical_logs_location, tempStore.getAbsolutePath()).setConfig(GraphDatabaseSettings.allow_upgrade, ((Boolean)this.config.get(GraphDatabaseSettings.allow_upgrade)).toString()).setConfig(GraphDatabaseSettings.default_schema_provider, (String)this.config.get(GraphDatabaseSettings.default_schema_provider)).newGraphDatabase();
    }

    private StoreWriter decorateWithProgressIndicator(final StoreWriter actual) {
        return new StoreWriter(){
            private int totalFiles;

            @Override
            public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, int requiredElementAlignment) throws IOException {
                StoreCopyClient.this.log.info("Copying %s", new Object[]{path});
                long written = actual.write(path, data, temporaryBuffer, hasData, requiredElementAlignment);
                StoreCopyClient.this.log.info("Copied %s %s", new Object[]{path, Format.bytes((long)written)});
                ++this.totalFiles;
                return written;
            }

            @Override
            public void close() {
                actual.close();
                StoreCopyClient.this.log.info("Done, copied %s files", new Object[]{this.totalFiles});
            }
        };
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.mkdir()) {
            FileUtils.deleteRecursively((File)directory);
            directory.mkdir();
        }
    }

    private void checkCancellation(CancellationRequest cancellationRequest, File tempStore) throws IOException {
        if (cancellationRequest.cancellationRequested()) {
            this.log.info("Store copying was cancelled. Cleaning up temp-directories.");
            StoreCopyClient.cleanDirectory(tempStore);
        }
    }

    public static interface StoreCopyRequester {
        public Response<?> copyStore(StoreWriter var1);

        public void done();
    }
}

