/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.FileUtils;

public class StoreUtil {
    public static final String BRANCH_SUBDIRECTORY = "branched";
    private static final String[] DONT_MOVE_DIRECTORIES = new String[]{"metrics", "logs", "certificates"};
    public static final String TEMP_COPY_DIRECTORY_NAME = "temp-copy";
    private static final FileFilter STORE_FILE_FILTER = file -> {
        for (String directory : DONT_MOVE_DIRECTORIES) {
            if (!file.getName().equals(directory)) continue;
            return false;
        }
        return !StoreUtil.isBranchedDataRootDirectory(file) && !StoreUtil.isTemporaryCopy(file);
    };

    private StoreUtil() {
    }

    public static void cleanStoreDir(File databaseDirectory) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(databaseDirectory)) {
            FileUtils.deleteRecursively((File)file);
        }
    }

    public static File newBranchedDataDir(File databaseDirectory) {
        File result = StoreUtil.getBranchedDataDirectory(databaseDirectory, System.currentTimeMillis());
        result.mkdirs();
        return result;
    }

    public static void moveAwayDb(File databaseDirectory, File branchedDataDir) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(databaseDirectory)) {
            FileUtils.moveFileToDirectory((File)file, (File)branchedDataDir);
        }
    }

    public static void deleteRecursive(File databaseDirectory) throws IOException {
        FileUtils.deleteRecursively((File)databaseDirectory);
    }

    public static boolean isBranchedDataDirectory(File file) {
        return file.isDirectory() && file.getParentFile().getName().equals(BRANCH_SUBDIRECTORY) && StringUtils.isNumeric((CharSequence)file.getName());
    }

    public static File getBranchedDataRootDirectory(File databaseDirectory) {
        return new File(databaseDirectory, BRANCH_SUBDIRECTORY);
    }

    public static File getBranchedDataDirectory(File databaseDirectory, long timestamp) {
        return new File(StoreUtil.getBranchedDataRootDirectory(databaseDirectory), "" + timestamp);
    }

    public static File[] relevantDbFiles(File databaseDirectory) {
        if (!databaseDirectory.exists()) {
            return new File[0];
        }
        return databaseDirectory.listFiles(STORE_FILE_FILTER);
    }

    private static boolean isBranchedDataRootDirectory(File file) {
        return file.isDirectory() && BRANCH_SUBDIRECTORY.equals(file.getName());
    }

    private static boolean isTemporaryCopy(File file) {
        return file.isDirectory() && file.getName().equals(TEMP_COPY_DIRECTORY_NAME);
    }
}

