/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;
    private final FileSystemAbstraction fs;
    private final StoreCopyClientMonitor monitor;

    public ToFileStoreWriter(File graphDbStoreDir, FileSystemAbstraction fs, StoreCopyClientMonitor storeCopyClientMonitor) {
        this.basePath = graphDbStoreDir;
        this.fs = fs;
        this.monitor = storeCopyClientMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, int requiredElementAlignment) throws IOException {
        temporaryBuffer.clear();
        File file = new File(this.basePath, path);
        file.getParentFile().mkdirs();
        String fullFilePath = file.toString();
        this.monitor.startReceivingStoreFile(fullFilePath);
        try {
            long l = this.writeDataThroughFileSystem(file, data, temporaryBuffer, hasData);
            this.monitor.finishReceivingStoreFile(fullFilePath);
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.monitor.finishReceivingStoreFile(fullFilePath);
                throw throwable;
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    private long writeDataThroughFileSystem(File file, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        try (StoreChannel channel = this.fs.create(file);){
            long l = this.writeData(data, temporaryBuffer, hasData, (WritableByteChannel)channel);
            return l;
        }
    }

    private long writeData(ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, WritableByteChannel channel) throws IOException {
        long totalToWrite = 0L;
        long totalWritten = 0L;
        if (hasData) {
            while (data.read(temporaryBuffer) >= 0) {
                int bytesWritten;
                temporaryBuffer.flip();
                totalToWrite += (long)temporaryBuffer.limit();
                while ((totalWritten += (long)(bytesWritten = channel.write(temporaryBuffer))) < totalToWrite) {
                    if (bytesWritten >= 0) continue;
                    throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
                }
                temporaryBuffer.clear();
            }
        }
        return totalWritten;
    }

    @Override
    public void close() {
    }
}

