/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.Neo4jManager;

@Deprecated
public class ClusterMemberInfo
implements Serializable {
    private static final long serialVersionUID = -514433972115185753L;
    private String instanceId;
    private boolean available;
    private boolean alive;
    private String haRole;
    private String[] uris;
    private String[] roles;

    @ConstructorProperties(value={"instanceId", "available", "alive", "haRole", "uris", "roles"})
    public ClusterMemberInfo(String instanceId, boolean available, boolean alive, String haRole, String[] uris, String[] roles) {
        this.instanceId = instanceId;
        this.available = available;
        this.alive = alive;
        this.haRole = haRole;
        this.uris = uris;
        this.roles = roles;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public String getHaRole() {
        return this.haRole;
    }

    public String[] getUris() {
        return this.uris;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        return String.format("Neo4jHaInstance[id=%s,available=%s,haRole=%s,HA URI=%s]", this.instanceId, this.available, this.haRole, Arrays.toString(this.uris));
    }

    public Pair<Neo4jManager, HighAvailability> connect() {
        return this.connect(null, null);
    }

    public Pair<Neo4jManager, HighAvailability> connect(String username, String password) {
        URI address = null;
        for (String uri : this.uris) {
            if (!uri.startsWith("jmx")) continue;
        }
        if (address == null) {
            throw new IllegalStateException("The instance does not have a public JMX server.");
        }
        Neo4jManager manager = Neo4jManager.get(this.url(address), username, password, this.instanceId);
        return Pair.of((Object)manager, (Object)manager.getHighAvailabilityBean());
    }

    private JMXServiceURL url(URI address) {
        try {
            return new JMXServiceURL(address.toASCIIString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The instance does not have a valid JMX server URL.");
        }
    }
}

