/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.management.IndexSamplingManager;
import org.neo4j.storageengine.api.StorageEngine;

@Deprecated
public final class IndexSamplingManagerBean
extends ManagementBeanProvider {
    public IndexSamplingManagerBean() {
        super(IndexSamplingManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new IndexSamplingManagerImpl(management);
    }

    protected Neo4jMBean createMXBean(ManagementData management) {
        return new IndexSamplingManagerImpl(management, true);
    }

    private static StoreAccess access(ManagementData management) {
        StoreAccess access = new StoreAccess();
        management.getKernelData().getDataSourceManager().addListener((DataSourceManager.Listener)access);
        return access;
    }

    static class StoreAccess
    implements DataSourceManager.Listener {
        private volatile State state;

        StoreAccess() {
        }

        public void registered(NeoStoreDataSource dataSource) {
            DependencyResolver dependencyResolver = dataSource.getDependencyResolver();
            this.state = new State((StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class), (IndexingService)dependencyResolver.resolveDependency(IndexingService.class), (TokenHolders)dependencyResolver.resolveDependency(TokenHolders.class));
        }

        public void unregistered(NeoStoreDataSource dataSource) {
            this.state = null;
        }

        public void triggerIndexSampling(String labelKey, String propertyKey, boolean forceSample) {
            int labelKeyId = -1;
            int propertyKeyId = -1;
            State state = this.state;
            if (state != null) {
                labelKeyId = state.tokenHolders.labelTokens().getIdByName(labelKey);
                propertyKeyId = state.tokenHolders.propertyKeyTokens().getIdByName(propertyKey);
            }
            if (state == null || labelKeyId == -1 || propertyKeyId == -1) {
                throw new IllegalArgumentException("No property or label key was found associated with " + propertyKey + " and " + labelKey);
            }
            try {
                state.indexingService.triggerIndexSampling((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelKeyId, (int[])new int[]{propertyKeyId}), this.getIndexSamplingMode(forceSample));
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        private IndexSamplingMode getIndexSamplingMode(boolean forceSample) {
            if (forceSample) {
                return IndexSamplingMode.TRIGGER_REBUILD_ALL;
            }
            return IndexSamplingMode.TRIGGER_REBUILD_UPDATED;
        }

        private static class State {
            final StorageEngine storageEngine;
            final IndexingService indexingService;
            final TokenHolders tokenHolders;

            State(StorageEngine storageEngine, IndexingService indexingService, TokenHolders tokenHolders) {
                this.storageEngine = storageEngine;
                this.indexingService = indexingService;
                this.tokenHolders = tokenHolders;
            }
        }
    }

    private static class IndexSamplingManagerImpl
    extends Neo4jMBean
    implements IndexSamplingManager {
        private final StoreAccess access;

        IndexSamplingManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.access = IndexSamplingManagerBean.access(management);
        }

        IndexSamplingManagerImpl(ManagementData management, boolean mxBean) {
            super(management, mxBean, new String[0]);
            this.access = IndexSamplingManagerBean.access(management);
        }

        @Override
        public void triggerIndexSampling(String labelKey, String propertyKey, boolean forceSample) {
            this.access.triggerIndexSampling(labelKey, propertyKey, forceSample);
        }
    }
}

