/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ClusterStateLock;
import com.hazelcast.internal.cluster.impl.ClusterStateTransactionLogRecord;
import com.hazelcast.internal.cluster.impl.operations.LockClusterStateOperation;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public class ClusterStateManager {
    private static final TransactionOptions DEFAULT_TX_OPTIONS = new TransactionOptions().setDurability(1).setTimeout(1L, TimeUnit.MINUTES).setTransactionType(TransactionOptions.TransactionType.TWO_PHASE);
    private static final long LOCK_LEASE_EXTENSION_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private final Node node;
    private final ILogger logger;
    private final Lock clusterServiceLock;
    private final AtomicReference<ClusterStateLock> stateLockRef = new AtomicReference<ClusterStateLock>(ClusterStateLock.NOT_LOCKED);
    private volatile ClusterState state = ClusterState.ACTIVE;

    ClusterStateManager(Node node, Lock clusterServiceLock) {
        this.node = node;
        this.clusterServiceLock = clusterServiceLock;
        this.logger = node.getLogger(this.getClass());
    }

    public ClusterState getState() {
        ClusterStateLock stateLock = this.getStateLock();
        return stateLock.isLocked() ? ClusterState.IN_TRANSITION : this.state;
    }

    ClusterStateLock getStateLock() {
        ClusterStateLock stateLock = this.stateLockRef.get();
        while (stateLock.isLeaseExpired()) {
            if (this.stateLockRef.compareAndSet(stateLock, ClusterStateLock.NOT_LOCKED)) {
                stateLock = ClusterStateLock.NOT_LOCKED;
                break;
            }
            stateLock = this.stateLockRef.get();
        }
        return stateLock;
    }

    void initialClusterState(ClusterState initialState) {
        this.clusterServiceLock.lock();
        try {
            ClusterState currentState = this.getState();
            if (currentState != ClusterState.ACTIVE && currentState != initialState) {
                this.logger.warning("Initial state is already set! Current state: " + (Object)((Object)currentState) + ", Given state: " + (Object)((Object)initialState));
                return;
            }
            this.state = initialState;
            this.changeNodeState(initialState);
            this.node.getNodeExtension().onClusterStateChange(initialState, false);
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    void setClusterState(ClusterState newState, boolean persistentChange) {
        this.clusterServiceLock.lock();
        try {
            this.state = newState;
            this.stateLockRef.set(ClusterStateLock.NOT_LOCKED);
            this.changeNodeState(newState);
            this.node.getNodeExtension().onClusterStateChange(newState, persistentChange);
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    void reset() {
        this.clusterServiceLock.lock();
        try {
            this.state = ClusterState.ACTIVE;
            this.stateLockRef.set(ClusterStateLock.NOT_LOCKED);
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockClusterState(ClusterState newState, Address initiator, String txnId, long leaseTime, int partitionStateVersion) {
        Preconditions.checkNotNull(newState);
        this.clusterServiceLock.lock();
        try {
            if (!this.node.getNodeExtension().isStartCompleted()) {
                throw new IllegalStateException("Can not lock cluster state! Startup is not completed yet!");
            }
            this.checkMigrationsAndPartitionStateVersion(newState, partitionStateVersion);
            ClusterStateLock currentLock = this.getStateLock();
            if (!currentLock.allowsLock(txnId)) {
                throw new TransactionException("Locking failed for " + initiator + ", tx: " + txnId + ", current state: " + this.toString());
            }
            this.stateLockRef.set(new ClusterStateLock(initiator, txnId, leaseTime));
            try {
                this.checkMigrationsAndPartitionStateVersion(newState, partitionStateVersion);
            }
            catch (IllegalStateException e) {
                this.stateLockRef.set(ClusterStateLock.NOT_LOCKED);
                throw e;
            }
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private void checkMigrationsAndPartitionStateVersion(ClusterState newState, int partitionStateVersion) {
        InternalPartitionService partitionService = this.node.getPartitionService();
        int thisPartitionStateVersion = partitionService.getPartitionStateVersion();
        if (partitionService.hasOnGoingMigrationLocal()) {
            throw new IllegalStateException("Still have pending migration tasks, cannot lock cluster state! New state: " + (Object)((Object)newState) + ", current state: " + (Object)((Object)this.getState()));
        }
        if (partitionStateVersion != thisPartitionStateVersion) {
            throw new IllegalStateException("Can not lock cluster state! Partition tables have different versions! Expected version: " + partitionStateVersion + " Current version: " + thisPartitionStateVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollbackClusterState(String txnId) {
        this.clusterServiceLock.lock();
        try {
            ClusterStateLock currentLock = this.getStateLock();
            if (!currentLock.allowsUnlock(txnId)) {
                boolean bl = false;
                return bl;
            }
            this.stateLockRef.set(ClusterStateLock.NOT_LOCKED);
            if (this.state == ClusterState.ACTIVE) {
                this.node.getClusterService().removeMembersDeadWhileClusterIsNotActive();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitClusterState(ClusterState newState, Address initiator, String txnId) {
        Preconditions.checkNotNull(newState);
        if (newState == ClusterState.IN_TRANSITION) {
            throw new IllegalArgumentException("IN_TRANSITION is an internal state!");
        }
        this.clusterServiceLock.lock();
        try {
            ClusterStateLock stateLock = this.getStateLock();
            if (!stateLock.allowsUnlock(txnId)) {
                throw new TransactionException("Cluster state change [" + (Object)((Object)this.state) + " -> " + (Object)((Object)newState) + "] failed for " + initiator + ", current state: " + this.stateToString());
            }
            this.state = newState;
            this.stateLockRef.set(ClusterStateLock.NOT_LOCKED);
            this.changeNodeState(newState);
            this.node.getNodeExtension().onClusterStateChange(newState, true);
            if (newState == ClusterState.ACTIVE) {
                this.node.getClusterService().removeMembersDeadWhileClusterIsNotActive();
            }
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private void changeNodeState(ClusterState newState) {
        if (newState == ClusterState.PASSIVE) {
            this.node.changeNodeStateToPassive();
        } else {
            this.node.changeNodeStateToActive();
        }
    }

    void changeClusterState(ClusterState newState, Collection<Member> members, int partitionStateVersion) {
        this.changeClusterState(newState, members, DEFAULT_TX_OPTIONS, partitionStateVersion);
    }

    void changeClusterState(ClusterState newState, Collection<Member> members, TransactionOptions options, int partitionStateVersion) {
        this.checkParameters(newState, options);
        if (this.getState() == newState) {
            return;
        }
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        TransactionManagerServiceImpl txManagerService = (TransactionManagerServiceImpl)nodeEngine.getTransactionManagerService();
        Transaction tx = txManagerService.newAllowedDuringPassiveStateTransaction(options);
        tx.begin();
        try {
            String txnId = tx.getTxnId();
            this.addTransactionRecords(newState, tx, members, partitionStateVersion);
            this.lockClusterState(newState, nodeEngine, options.getTimeoutMillis(), txnId, members, partitionStateVersion);
            this.checkMemberListChange(members);
            tx.prepare();
        }
        catch (Throwable e) {
            tx.rollback();
            throw ExceptionUtil.rethrow(e);
        }
        try {
            tx.commit();
        }
        catch (Throwable e) {
            if (e instanceof TargetNotMemberException || e.getCause() instanceof MemberLeftException) {
                return;
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void lockClusterState(ClusterState newState, NodeEngineImpl nodeEngine, long leaseTime, String txnId, Collection<Member> members, int partitionStateVersion) {
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        Address thisAddress = this.node.getThisAddress();
        for (Member member : members) {
            LockClusterStateOperation op = new LockClusterStateOperation(newState, thisAddress, txnId, leaseTime, partitionStateVersion);
            InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnTarget("hz:core:clusterService", op, member.getAddress());
            futures.add(future);
        }
        StateManagerExceptionHandler exceptionHandler = new StateManagerExceptionHandler(this.logger);
        FutureUtil.waitWithDeadline(futures, leaseTime, TimeUnit.MILLISECONDS, exceptionHandler);
        exceptionHandler.rethrowIfFailed();
    }

    private void addTransactionRecords(ClusterState newState, Transaction tx, Collection<Member> members, int partitionStateVersion) {
        long leaseTime = Math.min(tx.getTimeoutMillis(), LOCK_LEASE_EXTENSION_MILLIS);
        for (Member member : members) {
            tx.add(new ClusterStateTransactionLogRecord(newState, this.node.getThisAddress(), member.getAddress(), tx.getTxnId(), leaseTime, partitionStateVersion));
        }
    }

    private void checkMemberListChange(Collection<Member> members) {
        Set<Member> currentMembers = this.node.getClusterService().getMembers();
        if (members.size() != currentMembers.size()) {
            throw new IllegalStateException("Cluster members changed during state change!");
        }
        for (Member member : currentMembers) {
            if (members.contains(member)) continue;
            throw new IllegalStateException("Cluster members changed during state change!");
        }
    }

    private void checkParameters(ClusterState newState, TransactionOptions options) {
        Preconditions.checkNotNull(newState);
        Preconditions.checkNotNull(options);
        if (newState == ClusterState.IN_TRANSITION) {
            throw new IllegalArgumentException("IN_TRANSITION is an internal state!");
        }
        if (options.getTransactionType() != TransactionOptions.TransactionType.TWO_PHASE) {
            throw new IllegalArgumentException("Changing cluster state requires 2PC transaction!");
        }
    }

    String stateToString() {
        return "ClusterState{state=" + (Object)((Object)this.state) + ", lock=" + this.stateLockRef.get() + '}';
    }

    public String toString() {
        return "ClusterStateManager{stateLockRef=" + this.stateLockRef + ", state=" + (Object)((Object)this.state) + '}';
    }

    private static final class StateManagerExceptionHandler
    implements FutureUtil.ExceptionHandler {
        private final ILogger logger;
        private Throwable error;

        private StateManagerExceptionHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void handleException(Throwable throwable) {
            Throwable cause = throwable;
            if (throwable instanceof ExecutionException && throwable.getCause() != null) {
                cause = throwable.getCause();
            }
            if (this.error == null) {
                this.error = cause;
            }
            this.log(cause);
        }

        private void log(Throwable cause) {
            if (this.logger.isFineEnabled()) {
                this.logger.log(Level.FINE, "failure during cluster state change", cause);
            }
        }

        void rethrowIfFailed() {
            if (this.error != null) {
                throw ExceptionUtil.rethrow(this.error);
            }
        }
    }
}

