/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.Source;

public abstract class CharReadableChunker
implements Chunker {
    protected final CharReadable reader;
    protected final int chunkSize;
    protected volatile long position;
    private char[] backBuffer;
    private int backBufferCursor;

    public CharReadableChunker(CharReadable reader, int chunkSize) {
        this.reader = reader;
        this.chunkSize = chunkSize;
        this.backBuffer = new char[chunkSize >> 4];
    }

    @Override
    public ChunkImpl newChunk() {
        return new ChunkImpl(new char[this.chunkSize]);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long position() {
        return this.position;
    }

    protected int fillFromBackBuffer(char[] into) {
        if (this.backBufferCursor > 0) {
            assert (this.backBufferCursor < this.chunkSize);
            System.arraycopy(this.backBuffer, 0, into, 0, this.backBufferCursor);
            int result = this.backBufferCursor;
            this.backBufferCursor = 0;
            return result;
        }
        return 0;
    }

    protected int storeInBackBuffer(char[] data, int offset, int length) {
        System.arraycopy(data, offset, this.backBuffer(length), this.backBufferCursor, length);
        this.backBufferCursor += length;
        return length;
    }

    private char[] backBuffer(int length) {
        if (this.backBufferCursor + length > this.backBuffer.length) {
            this.backBuffer = Arrays.copyOf(this.backBuffer, this.backBufferCursor + length);
        }
        return this.backBuffer;
    }

    public static class ChunkImpl
    implements Source.Chunk {
        final char[] buffer;
        private int length;
        private String sourceDescription;

        public ChunkImpl(char[] buffer) {
            this.buffer = buffer;
        }

        public void initialize(int length, String sourceDescription) {
            this.length = length;
            this.sourceDescription = sourceDescription;
        }

        @Override
        public int startPosition() {
            return 0;
        }

        @Override
        public String sourceDescription() {
            return this.sourceDescription;
        }

        @Override
        public int maxFieldSize() {
            return this.buffer.length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char[] data() {
            return this.buffer;
        }

        @Override
        public int backPosition() {
            return 0;
        }
    }
}

