/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$ClusterLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetector;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011=t!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\u0011}\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u000443\t\u0007I\u0011\u0002\u001b\u0002/)|\u0017N\\\"p]\u001aLwmQ8na\u0006$8\t[3dW\u0016\u0014X#A\u001b\u0011\u0005!1\u0014BA\u001c\u0003\u0005]Qu.\u001b8D_:4\u0017nZ\"p[B\fGo\u00115fG.,'\u000f\u0003\u0004:3\u0001\u0006I!N\u0001\u0019U>LgnQ8oM&<7i\\7qCR\u001c\u0005.Z2lKJ\u0004\u0003bB\u001e\u001a\u0005\u0004%\t\u0001P\u0001\u0012g\u0016dg-\u00168jcV,\u0017\t\u001a3sKN\u001cX#A\u001f\u0011\u0005!q\u0014BA \u0003\u00055)f.[9vK\u0006#GM]3tg\"1\u0011)\u0007Q\u0001\nu\n!c]3mMVs\u0017.];f\u0003\u0012$'/Z:tA!)1)\u0007C\u0001\t\u0006Y1/\u001a7g\u0003\u0012$'/Z:t+\u0005)\u0005CA\nG\u0013\t9ECA\u0004BI\u0012\u0014Xm]:\t\u000b%KB\u0011\u0001&\u0002\u001dM,GN\u001a#bi\u0006\u001cUM\u001c;feV\t1\n\u0005\u0002M-:\u0011Q\n\u0016\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\t)&!A\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0013\t9\u0006L\u0001\u0006ECR\f7)\u001a8uKJT!!\u0016\u0002\t\u000biKB\u0011A.\u0002\u0013M,GN\u001a*pY\u0016\u001cX#\u0001/\u0011\u0007u\u00037M\u0004\u0002\u000e=&\u0011qLD\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'aA*fi*\u0011qL\u0004\t\u0003;\u0012L!!\u001a2\u0003\rM#(/\u001b8h\u0011\u00159\u0017\u0004\"\u0001i\u000319W\r^*fY\u001a\u0014v\u000e\\3t+\u0005I\u0007c\u00016pG6\t1N\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!!Y6\t\u000fEL\"\u0019!C\u0005e\u0006iq,[:UKJl\u0017N\\1uK\u0012,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fa!\u0019;p[&\u001c'B\u0001=l\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003uV\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007B\u0002?\u001aA\u0003%1/\u0001\b`SN$VM]7j]\u0006$X\r\u001a\u0011\t\u000fyL\"\u0019!C\u0005\u007f\u0006\u0019An\\4\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA!A\u0003fm\u0016tG/\u0003\u0003\u0002\f\u0005\u0015!A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\t\u0003\u001fI\u0002\u0015!\u0003\u0002\u0002\u0005!An\\4!\u0011%\t\u0019\"\u0007a\u0001\n\u0013\t)\"\u0001\u0006dYV\u001cH/\u001a:K[b,\"!a\u0006\u0011\u000b5\tI\"!\b\n\u0007\u0005maB\u0001\u0004PaRLwN\u001c\t\u0004\u0011\u0005}\u0011bAA\u0011\u0005\tQ1\t\\;ti\u0016\u0014(*\u001c=\t\u0013\u0005\u0015\u0012\u00041A\u0005\n\u0005\u001d\u0012AD2mkN$XM\u001d&nq~#S-\u001d\u000b\u0005\u0003S\ty\u0003E\u0002\u000e\u0003WI1!!\f\u000f\u0005\u0011)f.\u001b;\t\u0015\u0005E\u00121EA\u0001\u0002\u0004\t9\"A\u0002yIEB\u0001\"!\u000e\u001aA\u0003&\u0011qC\u0001\fG2,8\u000f^3s\u00156D\b\u0005C\u0005\u0002:e\u0011\r\u0011\"\u0001\u0002<\u0005ya-Y5mkJ,G)\u001a;fGR|'/\u0006\u0002\u0002>A)\u0011qHA#\u000b6\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\"\u0011A\u0002:f[>$X-\u0003\u0003\u0002H\u0005\u0005#a\u0006$bS2,(/\u001a#fi\u0016\u001cGo\u001c:SK\u001eL7\u000f\u001e:z\u0011!\tY%\u0007Q\u0001\n\u0005u\u0012\u0001\u00054bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0011%\ty%\u0007b\u0001\n\u0003\tY$\u0001\fde>\u001c8\u000fR2GC&dWO]3EKR,7\r^8s\u0011!\t\u0019&\u0007Q\u0001\n\u0005u\u0012aF2s_N\u001cHi\u0019$bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0011)\t9&\u0007EC\u0002\u0013\u0005\u0011\u0011L\u0001\u0010I><h.\u001b8h!J|g/\u001b3feV\u0011\u00111\f\t\u0004\u0011\u0005u\u0013bAA0\u0005\tyAi\\<oS:<\u0007K]8wS\u0012,'\u000f\u0003\u0006\u0002deA\t\u0011)Q\u0005\u00037\n\u0001\u0003Z8x]&tw\r\u0015:pm&$WM\u001d\u0011\t\u0015\u0005\u001d\u0014D1A\u0005\u0002\t\tI'A\u0005tG\",G-\u001e7feV\u0011\u00111\u000e\t\u0004'\u00055\u0014bAA8)\tI1k\u00195fIVdWM\u001d\u0005\t\u0003gJ\u0002\u0015!\u0003\u0002l\u0005Q1o\u00195fIVdWM\u001d\u0011\t\u0013\u0005]\u0014D1A\u0005\n\u0005e\u0014AD2mkN$XM\u001d#bK6|gn]\u000b\u0003\u0003w\u00022aEA?\u0013\r\ty\b\u0006\u0002\t\u0003\u000e$xN\u001d*fM\"A\u00111Q\r!\u0002\u0013\tY(A\bdYV\u001cH/\u001a:EC\u0016lwN\\:!\u0011)\t9)\u0007b\u0001\n\u0003\u0011\u0011\u0011P\u0001\fG2,8\u000f^3s\u0007>\u0014X\r\u0003\u0005\u0002\ff\u0001\u000b\u0011BA>\u00031\u0019G.^:uKJ\u001cuN]3!\u0011)\ty)\u0007b\u0001\n\u0003\u0011\u0011\u0011S\u0001\te\u0016\fGMV5foV\u0011\u00111\u0013\t\u0004\u0011\u0005U\u0015bAAL\u0005\ty1\t\\;ti\u0016\u0014(+Z1e-&,w\u000f\u0003\u0005\u0002\u001cf\u0001\u000b\u0011BAJ\u0003%\u0011X-\u00193WS\u0016<\b\u0005C\u0004\u0002 f!\t!!)\u0002\u0019%\u001cH+\u001a:nS:\fG/\u001a3\u0016\u0005\u0005\r\u0006cA\u0007\u0002&&\u0019\u0011q\u0015\b\u0003\u000f\t{w\u000e\\3b]\"9\u00111V\r\u0005\u0002\u00055\u0016!B:uCR,WCAAX!\u0011\t\t,a.\u000f\u0007!\t\u0019,C\u0002\u00026\n\tAb\u00117vgR,'/\u0012<f]RLA!!/\u0002<\n\u00192)\u001e:sK:$8\t\\;ti\u0016\u00148\u000b^1uK*\u0019\u0011Q\u0017\u0002\t\u000f\u0005}\u0016\u0004\"\u0001\u0002B\u0006Q1/\u001a7g\u001b\u0016l'-\u001a:\u0016\u0005\u0005\r\u0007c\u0001\u0005\u0002F&\u0019\u0011q\u0019\u0002\u0003\r5+WNY3s\u0011\u001d\tY-\u0007C\u0001\u0003\u001b\f\u0011b];cg\u000e\u0014\u0018NY3\u0015\r\u0005%\u0012qZAj\u0011!\t\t.!3A\u0002\u0005m\u0014AC:vEN\u001c'/\u001b2fe\"A\u0011Q[Ae\u0001\u0004\t9.\u0001\u0002u_B)Q\"!7\u0002^&\u0019\u00111\u001c\b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\r\u0003\u0002`\u0006%\b#B/\u0002b\u0006\u0015\u0018bAArE\n)1\t\\1tgB!\u0011q]Au\u0019\u0001!A\"a;\u0002T\u0006\u0005\t\u0011!B\u0001\u0003[\u00141a\u0018\u00132#\u0011\ty/!>\u0011\u00075\t\t0C\u0002\u0002t:\u0011qAT8uQ&tw\rE\u0002\u000e\u0003oL1!!?\u000f\u0005\r\te.\u001f\u0015\u0005\u0003\u0013\fi\u0010\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019AD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0004\u0005\u0003\u0011qA^1sCJ<7\u000fC\u0004\u0002Lf!\tAa\u0003\u0015\u0011\u0005%\"Q\u0002B\b\u00053A\u0001\"!5\u0003\n\u0001\u0007\u00111\u0010\u0005\t\u0005#\u0011I\u00011\u0001\u0003\u0014\u0005\u0001\u0012N\\5uS\u0006d7\u000b^1uK6{G-\u001a\t\u0005\u0003c\u0013)\"\u0003\u0003\u0003\u0018\u0005m&\u0001H*vEN\u001c'/\u001b9uS>t\u0017J\\5uS\u0006d7\u000b^1uK6{G-\u001a\u0005\t\u0003+\u0014I\u00011\u0001\u0003\u001cA)Q\"!7\u0003\u001eA\"!q\u0004B\u0012!\u0015i\u0016\u0011\u001dB\u0011!\u0011\t9Oa\t\u0005\u0019\t\u0015\"\u0011DA\u0001\u0002\u0003\u0015\t!!<\u0003\u0007}##\u0007\u000b\u0003\u0003\n\u0005u\bb\u0002B\u00163\u0011\u0005!QF\u0001\fk:\u001cXOY:de&\u0014W\r\u0006\u0003\u0002*\t=\u0002\u0002CAi\u0005S\u0001\r!a\u001f\t\u000f\t-\u0012\u0004\"\u0001\u00034Q1\u0011\u0011\u0006B\u001b\u0005oA\u0001\"!5\u00032\u0001\u0007\u00111\u0010\u0005\t\u0003+\u0014\t\u00041\u0001\u0003:A\"!1\bB !\u0015i\u0016\u0011\u001dB\u001f!\u0011\t9Oa\u0010\u0005\u0019\t\u0005#qGA\u0001\u0002\u0003\u0015\t!!<\u0003\u0007}#3\u0007C\u0004\u0003Fe!\tAa\u0012\u0002/M,g\u000eZ\"veJ,g\u000e^\"mkN$XM]*uCR,G\u0003BA\u0015\u0005\u0013B\u0001Ba\u0013\u0003D\u0001\u0007\u00111P\u0001\te\u0016\u001cW-\u001b<fe\"9!qJ\r\u0005\u0002\tE\u0013\u0001\u00026pS:$B!!\u000b\u0003T!9!Q\u000bB'\u0001\u0004)\u0015aB1eIJ,7o\u001d\u0005\b\u00053JB\u0011\u0002B.\u0003%1\u0017\u000e\u001c7M_\u000e\fG\u000eF\u0002F\u0005;BqA!\u0016\u0003X\u0001\u0007Q\tC\u0004\u0003be!\tAa\u0019\u0002\u001b)|\u0017N\\*fK\u0012tu\u000eZ3t)\u0011\tIC!\u001a\t\u0011\t\u001d$q\fa\u0001\u0005S\n\u0011b]3fI:{G-Z:\u0011\u000b\t-$QO#\u000e\u0005\t5$\u0002\u0002B8\u0005c\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\tMd\"\u0001\u0006d_2dWm\u0019;j_:LAAa\u001e\u0003n\t\u00191+Z9\t\u000f\t\u0005\u0014\u0004\"\u0001\u0003|Q!\u0011\u0011\u0006B?\u0011!\u00119G!\u001fA\u0002\t}\u0004\u0003\u00026\u0003\u0002\u0016K1Aa!l\u0005\u0011a\u0015n\u001d;\t\u000f\t\u001d\u0015\u0004\"\u0001\u0003\n\u0006)A.Z1wKR!\u0011\u0011\u0006BF\u0011\u001d\u0011)F!\"A\u0002\u0015CqAa$\u001a\t\u0003\u0011\t*\u0001\u0003e_^tG\u0003BA\u0015\u0005'CqA!\u0016\u0003\u000e\u0002\u0007Q\tC\u0004\u0003\u0018f!\tA!'\u0002%I,w-[:uKJ|e.T3nE\u0016\u0014X\u000b]\u000b\u0005\u00057\u0013I\u000b\u0006\u0003\u0002*\tu\u0005\"\u0003BP\u0005+#\t\u0019\u0001BQ\u0003\u0011\u0019w\u000eZ3\u0011\u000b5\u0011\u0019Ka*\n\u0007\t\u0015fB\u0001\u0005=Eft\u0017-\\3?!\u0011\t9O!+\u0005\u0011\t-&Q\u0013b\u0001\u0003[\u0014\u0011\u0001\u0016\u0005\b\u0005/KB\u0011\u0001BX)\u0011\tIC!-\t\u0011\tM&Q\u0016a\u0001\u0005k\u000b\u0001bY1mY\n\f7m\u001b\t\u0005\u0005o\u0013i,\u0004\u0002\u0003:*\u0019!1X7\u0002\t1\fgnZ\u0005\u0005\u0005\u007f\u0013IL\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\u0011\u0019-\u0007C\u0001\u0005\u000b\fqC]3hSN$XM](o\u001b\u0016l'-\u001a:SK6|g/\u001a3\u0016\t\t\u001d'q\u001a\u000b\u0005\u0003S\u0011I\rC\u0005\u0003 \n\u0005G\u00111\u0001\u0003LB)QBa)\u0003NB!\u0011q\u001dBh\t!\u0011YK!1C\u0002\u00055\bb\u0002Bb3\u0011\u0005!1\u001b\u000b\u0005\u0003S\u0011)\u000e\u0003\u0005\u00034\nE\u0007\u0019\u0001B[\u0011\u001d\u0011I.\u0007C\u0001\u00057\fAB]3n_R,\u0007+\u0019;i\u001f\u001a$BA!8\u0003dB\u00191Ca8\n\u0007\t\u0005HCA\u0005BGR|'\u000fU1uQ\"A!Q\u001dBl\u0001\u0004\tY(\u0001\u0005bGR|'OU3g\u0011!\u0011I/\u0007C\u0001\u0005\t-\u0018\u0001C:ikR$wn\u001e8\u0015\u0005\u0005%\u0002\u0006\u0002Bt\u0005_\u0004BA!=\u0003v6\u0011!1\u001f\u0006\u0004\u0005\u0007!\u0011\u0002\u0002B|\u0005g\u00141\"\u00138uKJt\u0017\r\\!qS\"9!1`\r\u0005\n\t-\u0018AD2m_N,7k\u00195fIVdWM]\u0004\t\u0005\u007fL\u0002\u0012\u0001\u0002\u0004\u0002\u0005i1\t\\;ti\u0016\u0014Hj\\4hKJ\u0004Baa\u0001\u0004\u00065\t\u0011D\u0002\u0005\u0004\beA\tAAB\u0005\u00055\u0019E.^:uKJdunZ4feN\u00191Q\u0001\u0007\t\u000f\u001d\u001a)\u0001\"\u0001\u0004\u000eQ\u00111\u0011\u0001\u0005\t\u0007#\u0019)\u0001\"\u0001\u0002\"\u0006q\u0011n\u001d#fEV<WI\\1cY\u0016$\u0007\u0002CB\u000b\u0007\u000b!\taa\u0006\u0002\u00111|w\rR3ck\u001e$B!!\u000b\u0004\u001a!911DB\n\u0001\u0004\u0019\u0017aB7fgN\fw-\u001a\u0005\t\u0007+\u0019)\u0001\"\u0001\u0004 Q1\u0011\u0011FB\u0011\u0007KAqaa\t\u0004\u001e\u0001\u00071-\u0001\u0005uK6\u0004H.\u0019;f\u0011!\u00199c!\bA\u0002\u0005U\u0018\u0001B1sOFB\u0001b!\u0006\u0004\u0006\u0011\u000511\u0006\u000b\t\u0003S\u0019ica\f\u00042!911EB\u0015\u0001\u0004\u0019\u0007\u0002CB\u0014\u0007S\u0001\r!!>\t\u0011\rM2\u0011\u0006a\u0001\u0003k\fA!\u0019:he!A1QCB\u0003\t\u0003\u00199\u0004\u0006\u0006\u0002*\re21HB\u001f\u0007\u007fAqaa\t\u00046\u0001\u00071\r\u0003\u0005\u0004(\rU\u0002\u0019AA{\u0011!\u0019\u0019d!\u000eA\u0002\u0005U\b\u0002CB!\u0007k\u0001\r!!>\u0002\t\u0005\u0014xm\r\u0005\t\u0007\u000b\u001a)\u0001\"\u0001\u0004H\u00059An\\4J]\u001a|G\u0003BA\u0015\u0007\u0013Bqaa\u0007\u0004D\u0001\u00071\r\u0003\u0005\u0004F\r\u0015A\u0011AB')\u0019\tIca\u0014\u0004R!911EB&\u0001\u0004\u0019\u0007\u0002CB\u0014\u0007\u0017\u0002\r!!>\t\u0011\r\u00153Q\u0001C\u0001\u0007+\"\u0002\"!\u000b\u0004X\re31\f\u0005\b\u0007G\u0019\u0019\u00061\u0001d\u0011!\u00199ca\u0015A\u0002\u0005U\b\u0002CB\u001a\u0007'\u0002\r!!>\t\u0011\r\u00153Q\u0001C\u0001\u0007?\"\"\"!\u000b\u0004b\r\r4QMB4\u0011\u001d\u0019\u0019c!\u0018A\u0002\rD\u0001ba\n\u0004^\u0001\u0007\u0011Q\u001f\u0005\t\u0007g\u0019i\u00061\u0001\u0002v\"A1\u0011IB/\u0001\u0004\t)\u0010\u0003\u0005\u0004l\r\u0015A\u0011AB7\u0003)awnZ,be:Lgn\u001a\u000b\u0005\u0003S\u0019y\u0007C\u0004\u0004\u001c\r%\u0004\u0019A2\t\u0011\r-4Q\u0001C\u0001\u0007g\"b!!\u000b\u0004v\r]\u0004bBB\u0012\u0007c\u0002\ra\u0019\u0005\t\u0007O\u0019\t\b1\u0001\u0002v\"A11NB\u0003\t\u0003\u0019Y\b\u0006\u0005\u0002*\ru4qPBA\u0011\u001d\u0019\u0019c!\u001fA\u0002\rD\u0001ba\n\u0004z\u0001\u0007\u0011Q\u001f\u0005\t\u0007g\u0019I\b1\u0001\u0002v\"A11NB\u0003\t\u0003\u0019)\t\u0006\u0006\u0002*\r\u001d5\u0011RBF\u0007\u001bCqaa\t\u0004\u0004\u0002\u00071\r\u0003\u0005\u0004(\r\r\u0005\u0019AA{\u0011!\u0019\u0019da!A\u0002\u0005U\b\u0002CB!\u0007\u0007\u0003\r!!>\t\u0011\rE5Q\u0001C\u0001\u0007'\u000b\u0001\u0002\\8h\u000bJ\u0014xN\u001d\u000b\u0005\u0003S\u0019)\nC\u0004\u0004\u001c\r=\u0005\u0019A2\t\u0011\rE5Q\u0001C\u0001\u00073#b!!\u000b\u0004\u001c\u000eu\u0005bBB\u0012\u0007/\u0003\ra\u0019\u0005\t\u0007O\u00199\n1\u0001\u0002v\"A1\u0011SB\u0003\t\u0003\u0019\t\u000b\u0006\u0005\u0002*\r\r6QUBT\u0011\u001d\u0019\u0019ca(A\u0002\rD\u0001ba\n\u0004 \u0002\u0007\u0011Q\u001f\u0005\t\u0007g\u0019y\n1\u0001\u0002v\"A1\u0011SB\u0003\t\u0003\u0019Y\u000b\u0006\u0006\u0002*\r56qVBY\u0007gCqaa\t\u0004*\u0002\u00071\r\u0003\u0005\u0004(\r%\u0006\u0019AA{\u0011!\u0019\u0019d!+A\u0002\u0005U\b\u0002CB!\u0007S\u0003\r!!>\t\u0011\rE5Q\u0001C\u0001\u0007o#b!!\u000b\u0004:\u000e=\u0007\u0002CB^\u0007k\u0003\ra!0\u0002\u000b\r\fWo]3\u0011\t\r}6\u0011\u001a\b\u0005\u0007\u0003\u001c)MD\u0002P\u0007\u0007L\u0011aD\u0005\u0004\u0007\u000ft\u0011a\u00029bG.\fw-Z\u0005\u0005\u0007\u0017\u001ciMA\u0005UQJ|w/\u00192mK*\u00191q\u0019\b\t\u000f\rm1Q\u0017a\u0001G\"A1\u0011SB\u0003\t\u0003\u0019\u0019\u000e\u0006\u0005\u0002*\rU7q[Bm\u0011!\u0019Yl!5A\u0002\ru\u0006bBB\u0012\u0007#\u0004\ra\u0019\u0005\t\u0007O\u0019\t\u000e1\u0001\u0002v\"A1\u0011SB\u0003\t\u0003\u0019i\u000e\u0006\u0006\u0002*\r}7\u0011]Br\u0007KD\u0001ba/\u0004\\\u0002\u00071Q\u0018\u0005\b\u0007G\u0019Y\u000e1\u0001d\u0011!\u00199ca7A\u0002\u0005U\b\u0002CB\u001a\u00077\u0004\r!!>\t\u0011\rE5Q\u0001C\u0001\u0007S$B\"!\u000b\u0004l\u000e58q^By\u0007gD\u0001ba/\u0004h\u0002\u00071Q\u0018\u0005\b\u0007G\u00199\u000f1\u0001d\u0011!\u00199ca:A\u0002\u0005U\b\u0002CB\u001a\u0007O\u0004\r!!>\t\u0011\r\u00053q\u001da\u0001\u0003kD\u0001ba>\u0004\u0006\u0011%1\u0011`\u0001\u000bY><\u0017\t\u001e'fm\u0016dGCBA\u0015\u0007w$\t\u0002\u0003\u0005\u0004~\u000eU\b\u0019AB\u0000\u0003!awn\u001a'fm\u0016d\u0007\u0003\u0002C\u0001\t\u0017qA\u0001b\u0001\u0005\b9\u0019a\n\"\u0002\n\u0007\u0005\u001dA!\u0003\u0003\u0005\n\u0005\u0015\u0011a\u0002'pO\u001eLgnZ\u0005\u0005\t\u001b!yA\u0001\u0005M_\u001edUM^3m\u0015\u0011!I!!\u0002\t\u000f\rm1Q\u001fa\u0001G\"A1q_B\u0003\t\u0013!)\u0002\u0006\u0005\u0002*\u0011]A\u0011\u0004C\u000e\u0011!\u0019i\u0010b\u0005A\u0002\r}\bbBB\u0012\t'\u0001\ra\u0019\u0005\t\u0007O!\u0019\u00021\u0001\u0002v\"A1q_B\u0003\t\u0013!y\u0002\u0006\u0006\u0002*\u0011\u0005B1\u0005C\u0013\tOA\u0001b!@\u0005\u001e\u0001\u00071q \u0005\b\u0007G!i\u00021\u0001d\u0011!\u00199\u0003\"\bA\u0002\u0005U\b\u0002CB\u001a\t;\u0001\r!!>\t\u0011\r]8Q\u0001C\u0005\tW!B\"!\u000b\u0005.\u0011=B\u0011\u0007C\u001a\tkA\u0001b!@\u0005*\u0001\u00071q \u0005\b\u0007G!I\u00031\u0001d\u0011!\u00199\u0003\"\u000bA\u0002\u0005U\b\u0002CB\u001a\tS\u0001\r!!>\t\u0011\r\u0005C\u0011\u0006a\u0001\u0003kD\u0001\u0002\"\u000f\u0004\u0006\u0011%A1H\u0001\u000fSNdUM^3m\u000b:\f'\r\\3e)\u0011\t\u0019\u000b\"\u0010\t\u0011\ruHq\u0007a\u0001\u0007\u007f\u00042a\u0005C!\u0013\r!\u0019\u0005\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0007O%!\t\u0001b\u0012\u0015\u0003\u001dAq\u0001b\u0013\n\t\u0003\"i%A\u0002hKR$2\u0001\u0007C(\u0011\u001dyB\u0011\na\u0001\t#\u00022a\u0005C*\u0013\r!)\u0006\u0006\u0002\f\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0005Z%!\t\u0005b\u0017\u0002\r1|wn[;q)\t!iF\u0004\u0002\t\u0001!9A\u0011M\u0005\u0005B\u0011\r\u0014aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007a!)\u0007\u0003\u0004 \t?\u0002\r!\t\u0005\u000b\tSJ!\u0019!C\u0003\u0005\u0005\u0005\u0016!G5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012D\u0001\u0002\"\u001c\nA\u00035\u00111U\u0001\u001bSN\f5o]3si&sg/\u0019:jC:$8/\u00128bE2,G\r\t")
public class Cluster
implements Extension {
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private DowningProvider downingProvider;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile Cluster$ClusterLogger$ ClusterLogger$module;
    private volatile boolean bitmap$0;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
            return this.downingProvider;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cluster$ClusterLogger$ ClusterLogger$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.ClusterLogger$module != null) return this.ClusterLogger$module;
            this.ClusterLogger$module = new Cluster$ClusterLogger$(this);
            return this.ClusterLogger$module;
        }
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public DowningProvider downingProvider() {
        return this.bitmap$0 ? this.downingProvider : this.downingProvider$lzycompute();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "at least one `ClusterDomainEvent` class is required";
            }
        });
        Predef$.MODULE$.require(to.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Class<?> x$1) {
                return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
            }
        }), (Function0)new Serializable(this, to){
            public static final long serialVersionUID = 0L;
            private final Seq to$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.to$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Class<?> x$1) {
                        return x$1.getName();
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")}));
            }
            {
                this.to$1 = to$1;
            }
        });
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$6 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$7 = qual$2.$bang$default$2((Object)x$6);
        qual$2.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$9 = qual$3.$bang$default$2((Object)x$8);
        qual$3.$bang((Object)x$8, x$9);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$10 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$11 = qual$4.$bang$default$2((Object)x$10);
        qual$4.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$12 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$13 = qual$5.$bang$default$2((Object)x$12);
        qual$5.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$15 = qual$6.$bang$default$2((Object)x$14);
        qual$6.$bang((Object)x$14, x$15);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Address akka$cluster$Cluster$$fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cluster $outer;

            public final Address apply(Address address) {
                return this.$outer.akka$cluster$Cluster$$fillLocal(address);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Vector$.MODULE$.canBuildFrom())));
        ActorRef x$17 = qual$7.$bang$default$2((Object)x$16);
        qual$7.$bang((Object)x$16, x$17);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((scala.collection.immutable.Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$19 = qual$8.$bang$default$2((Object)x$18);
        qual$8.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$21 = qual$9.$bang$default$2((Object)x$20);
        qual$9.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(this, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$10.$bang$default$2((Object)x$22);
        qual$10.$bang((Object)x$22, x$23);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(this, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$24 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$25 = qual$11.$bang$default$2((Object)x$24);
            qual$11.$bang((Object)x$24, x$25);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$12 = path.root();
            Address x$26 = this.selfAddress();
            String x$27 = qual$12.copy$default$2();
            actorPath = qual$12.copy(x$26, x$27).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    @InternalApi
    public void shutdown() {
        if (this._isTerminated().compareAndSet(false, true)) {
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ClusterJmx x$2) {
                    x$2.unregisterMBean();
                }
            });
            this.ClusterLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Cluster$ClusterLogger$ ClusterLogger() {
        return this.ClusterLogger$module == null ? this.ClusterLogger$lzycompute() : this.ClusterLogger$module;
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$3 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$4 = timeout$1;
            ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$3);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$3, x$4, x$5).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            ActorRef actorRef2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            actorRef = actorRef2 = this.system().deadLetters();
        }
        return actorRef;
    }

    public Cluster(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (actorRefProvider instanceof ClusterActorRefProvider) {
            Scheduler scheduler;
            UniqueAddress uniqueAddress;
            ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
            this.selfUniqueAddress = uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
            this._isTerminated = new AtomicBoolean(false);
            this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
            this.clusterJmx = None$.MODULE$;
            this.ClusterLogger().logInfo("Starting up, Akka version [{}] ...", system.settings().ConfigVersion());
            Serializable createFailureDetector = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final FailureDetector apply() {
                    return FailureDetectorLoader$.MODULE$.load(this.$outer.settings().FailureDetectorImplementationClass(), this.$outer.settings().FailureDetectorConfig(), (ActorSystem)this.$outer.system());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
            Serializable createFailureDetector2 = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final FailureDetector apply() {
                    return FailureDetectorLoader$.MODULE$.load(this.$outer.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.$outer.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.$outer.system());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
            package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
            if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
                ThreadFactory threadFactory;
                this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
                Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
                ThreadFactory threadFactory2 = system.threadFactory();
                if (threadFactory2 instanceof MonitorableThreadFactory) {
                    MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                    threadFactory = monitorableThreadFactory.withName(new StringBuilder().append((Object)monitorableThreadFactory.name()).append((Object)"-cluster-scheduler").toString());
                } else {
                    threadFactory = threadFactory2;
                }
                ThreadFactory threadFactory3 = threadFactory;
                scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
            } else {
                Scheduler systemScheduler = system.scheduler();
                scheduler = new Scheduler(this, systemScheduler){
                    private final Scheduler systemScheduler$1;

                    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.schedule((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                    }

                    public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                        return Scheduler.class.schedule((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                    }

                    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                    }

                    public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                    }

                    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                        return Scheduler.class.schedule$default$6((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                    }

                    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                        return Scheduler.class.scheduleOnce$default$5((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                    }

                    public void close() {
                    }

                    public double maxFrequency() {
                        return this.systemScheduler$1.maxFrequency();
                    }

                    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                        return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                    }

                    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                        return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                    }
                    {
                        this.systemScheduler$1 = systemScheduler$1;
                        Scheduler.class.$init$((Scheduler)this);
                    }
                };
            }
            this.scheduler = scheduler;
            this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
            Timeout timeout = system.settings().CreationTimeout();
            this.clusterCore = this.liftedTree1$1(timeout);
            this.readView = new ClusterReadView(this);
            system.registerOnTermination((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (this.settings().JmxEnabled()) {
                ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
                jmx.createMBean();
                this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
            }
            this.ClusterLogger().logInfo("Started up successfully");
            return;
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have 'akka.actor.provider' set to 'cluster' in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
    }
}

