/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.annotation.InternalApi;
import akka.cluster.Gossip;
import akka.cluster.Member;
import akka.cluster.MembershipState;
import akka.cluster.UniqueAddress;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.SetLike;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0001\t\u0019\u0011AcR8tg&\u0004H+\u0019:hKR\u001cV\r\\3di>\u0014(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u000fA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001aD\u0001B\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001%e\u0016$WoY3H_N\u001c\u0018\u000e\u001d#jM\u001a,'/\u001a8u-&,w\u000f\u0015:pE\u0006\u0014\u0017\u000e\\5us\u000e\u0001\u0001C\u0001\u0005\u0012\u0013\t\u0011\u0012B\u0001\u0004E_V\u0014G.\u001a\u0005\t)\u0001\u0011\t\u0011)A\u0005!\u0005A2M]8tg\u0012\u001bwi\\:tSB\u0004&o\u001c2bE&d\u0017\u000e^=\t\u000bY\u0001A\u0011A\f\u0002\rqJg.\u001b;?)\rA\"d\u0007\t\u00033\u0001i\u0011A\u0001\u0005\u0006\u001dU\u0001\r\u0001\u0005\u0005\u0006)U\u0001\r\u0001\u0005\u0005\u0006;\u0001!)AH\u0001\rO>\u001c8/\u001b9UCJ<W\r\u001e\u000b\u0003?\u0015\u00022\u0001\u0003\u0011#\u0013\t\t\u0013B\u0001\u0004PaRLwN\u001c\t\u00033\rJ!\u0001\n\u0002\u0003\u001bUs\u0017.];f\u0003\u0012$'/Z:t\u0011\u00151C\u00041\u0001(\u0003\u0015\u0019H/\u0019;f!\tI\u0002&\u0003\u0002*\u0005\tyQ*Z7cKJ\u001c\b.\u001b9Ti\u0006$X\rC\u0003,\u0001\u0011\u0015A&A\u0007h_N\u001c\u0018\u000e\u001d+be\u001e,Go\u001d\u000b\u0003[e\u00022A\f\u001c#\u001d\tyCG\u0004\u00021g5\t\u0011G\u0003\u00023\u001f\u00051AH]8pizJ\u0011AC\u0005\u0003k%\tq\u0001]1dW\u0006<W-\u0003\u00028q\t1a+Z2u_JT!!N\u0005\t\u000b\u0019R\u0003\u0019A\u0014\t\u000bm\u0002A\u0011\u0001\u001f\u00021I\fg\u000eZ8n\u001d>$Wm\u001d$pe\u001a+H\u000e\\$pgNL\u0007\u000fF\u0002.{yBQA\n\u001eA\u0002\u001dBQa\u0010\u001eA\u0002\u0001\u000b\u0011A\u001c\t\u0003\u0011\u0005K!AQ\u0005\u0003\u0007%sG\u000fC\u0003E\u0001\u0011EQ)\u0001\u000bm_\u000e\fG\u000eR2H_N\u001c\u0018\u000e\u001d+be\u001e,Go\u001d\u000b\u0003[\u0019CQAJ\"A\u0002\u001dBQ\u0001\u0013\u0001\u0005\u0012%\u000bA#\\;mi&$5mR8tg&\u0004H+\u0019:hKR\u001cHCA\u0017K\u0011\u00151s\t1\u0001(\u0011\u0015a\u0005\u0001\"\u0005N\u0003\u0019\nGM[;ti\u0016$wi\\:tSB$\u0015N\u001a4fe\u0016tGOV5foB\u0013xNY1cS2LG/\u001f\u000b\u0003!9CQaT&A\u0002\u0001\u000b1b\u00197vgR,'oU5{K\")\u0011\u000b\u0001C\t%\u0006\u00112/\u001a7fGR$5\rT8dC2tu\u000eZ3t)\t\u0019f\u000b\u0005\u0002\t)&\u0011Q+\u0003\u0002\b\u0005>|G.Z1o\u0011\u00151\u0003\u000b1\u0001(\u0011\u0015A\u0006\u0001\"\u0005Z\u0003q\u0001(/\u001a4fe:{G-Z:XSRDG)\u001b4gKJ,g\u000e\u001e,jK^$\"a\u0015.\t\u000b\u0019:\u0006\u0019A\u0014\t\u000bq\u0003A\u0011C/\u0002!\u0011\u001c7/\u00138SC:$w.\\(sI\u0016\u0014HC\u00010m!\rqs,Y\u0005\u0003Ab\u0012A\u0001T5tiB\u0011!-\u001b\b\u0003G\u001et!\u0001\u001a4\u000f\u0005A*\u0017\"A\u0003\n\u0005\r!\u0011B\u00015\u0003\u0003=\u0019E.^:uKJ\u001cV\r\u001e;j]\u001e\u001c\u0018B\u00016l\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0003Q\nAQ!\\.A\u0002y\u000b1\u0001Z2t\u0011\u0015y\u0007\u0001\"\u0005q\u0003A\u0019X\r\\3diJ\u000bg\u000eZ8n\u001d>$W\r\u0006\u0002 c\")!O\u001ca\u0001g\u0006)an\u001c3fgB\u0019a\u0006\u001e\u0012\n\u0005UD$AC%oI\u0016DX\rZ*fc\"\u0012\u0001a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u\u0012\t!\"\u00198o_R\fG/[8o\u0013\ta\u0018PA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class GossipTargetSelector {
    private final double reduceGossipDifferentViewProbability;
    private final double crossDcGossipProbability;

    public final Option<UniqueAddress> gossipTarget(MembershipState state) {
        return this.selectRandomNode((IndexedSeq<UniqueAddress>)this.gossipTargets(state));
    }

    public final Vector<UniqueAddress> gossipTargets(MembershipState state) {
        return state.latestGossip().isMultiDc() ? this.multiDcGossipTargets(state) : this.localDcGossipTargets(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector<UniqueAddress> randomNodesForFullGossip(MembershipState state, int n) {
        Vector vector;
        if (state.latestGossip().isMultiDc() && ((SetLike)state.ageSortedTopOldestMembersPerDc().apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            Vector vector2;
            Vector randomLocalNodes = (Vector)Random$.MODULE$.shuffle((TraversableOnce)state.members().toVector().collect((PartialFunction)new Serializable(this, state){
                public static final long serialVersionUID = 0L;
                private final MembershipState state$1;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    A1 A1 = x6;
                    String string = A1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x6);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x6) {
                    Member member2 = x6;
                    String string = member2.dataCenter();
                    String string2 = this.state$1.selfDc();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(member2.uniqueAddress());
                    return bl;
                }
                {
                    this.state$1 = state$1;
                }
            }, Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            List otherDcs = (List)Random$.MODULE$.shuffle((TraversableOnce)state.ageSortedTopOldestMembersPerDc().keySet().$minus((Object)state.selfDc()).toList(), List$.MODULE$.canBuildFrom());
            Option option = this.selectOtherDcNode$1(otherDcs, state);
            if (option instanceof Some) {
                Some some = (Some)option;
                UniqueAddress node = (UniqueAddress)some.x();
                vector2 = (Vector)randomLocalNodes.take(n - 1).$colon$plus((Object)node, Vector$.MODULE$.canBuildFrom());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                vector2 = randomLocalNodes.take(n);
            }
            vector = vector2;
            return vector;
        } else {
            Vector selectedNodes = (Vector)state.members().toVector().collect((PartialFunction)new Serializable(this, state){
                public static final long serialVersionUID = 0L;
                private final MembershipState state$1;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    A1 A1 = x8;
                    String string = A1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x8);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x8) {
                    Member member2 = x8;
                    String string = member2.dataCenter();
                    String string2 = this.state$1.selfDc();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(member2.uniqueAddress());
                    return bl;
                }
                {
                    this.state$1 = state$1;
                }
            }, Vector$.MODULE$.canBuildFrom());
            vector = selectedNodes.size() <= n ? selectedNodes : ((Vector)Random$.MODULE$.shuffle((TraversableOnce)selectedNodes, Vector$.MODULE$.canBuildFrom())).take(n);
        }
        return vector;
    }

    public Vector<UniqueAddress> localDcGossipTargets(MembershipState state) {
        Gossip latestGossip = state.latestGossip();
        Vector firstSelection = this.preferNodesWithDifferentView(state) ? (Vector)latestGossip.members().iterator().collect((PartialFunction)new Serializable(this, state, latestGossip){
            public static final long serialVersionUID = 0L;
            private final MembershipState state$3;
            private final Gossip latestGossip$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Member, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x9;
                String string = A1.dataCenter();
                String string2 = this.state$3.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(A1.uniqueAddress()) && this.state$3.validNodeForGossip(A1.uniqueAddress())) {
                        object = A1.uniqueAddress();
                        return (B1)object;
                    }
                }
                object = function1.apply(x9);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Member x9) {
                Member member2 = x9;
                String string = member2.dataCenter();
                String string2 = this.state$3.selfDc();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (this.latestGossip$1.seenByNode(member2.uniqueAddress())) return false;
                if (!this.state$3.validNodeForGossip(member2.uniqueAddress())) return false;
                return true;
            }
            {
                this.state$3 = state$3;
                this.latestGossip$1 = latestGossip$1;
            }
        }).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)scala.package$.MODULE$.Vector())) : scala.package$.MODULE$.Vector().empty();
        return firstSelection.isEmpty() ? (Vector)latestGossip.members().toVector().collect((PartialFunction)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final MembershipState state$3;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                A1 A1 = x10;
                String string = A1.dataCenter();
                String string2 = this.state$3.selfDc();
                Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$3.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x10);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x10) {
                Member member2 = x10;
                String string = member2.dataCenter();
                String string2 = this.state$3.selfDc();
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$3.validNodeForGossip(member2.uniqueAddress());
                return bl;
            }
            {
                this.state$3 = state$3;
            }
        }, Vector$.MODULE$.canBuildFrom()) : firstSelection;
    }

    public Vector<UniqueAddress> multiDcGossipTargets(MembershipState state) {
        List<String> otherDcsInRandomOrder;
        Vector<UniqueAddress> nodes;
        Map<String, SortedSet<Member>> nodesPerDc;
        Vector<UniqueAddress> vector = this.selectDcLocalNodes(state) ? this.localDcGossipTargets(state) : (((SetLike)(nodesPerDc = state.ageSortedTopOldestMembersPerDc()).apply((Object)state.selfDc())).contains((Object)state.selfMember()) ? ((nodes = this.findFirstDcWithValidNodes$1(otherDcsInRandomOrder = this.dcsInRandomOrder((List<String>)nodesPerDc.$minus((Object)state.selfDc()).keys().toList()), state, nodesPerDc)).nonEmpty() ? nodes : this.localDcGossipTargets(state)) : this.localDcGossipTargets(state));
        return vector;
    }

    public double adjustedGossipDifferentViewProbability(int clusterSize) {
        double d;
        double low = this.reduceGossipDifferentViewProbability;
        double high = low * (double)3;
        if ((double)clusterSize <= low) {
            d = this.reduceGossipDifferentViewProbability;
        } else {
            double minP = this.reduceGossipDifferentViewProbability / (double)10;
            if ((double)clusterSize >= high) {
                d = minP;
            } else {
                double k = (minP - this.reduceGossipDifferentViewProbability) / (high - low);
                d = this.reduceGossipDifferentViewProbability + ((double)clusterSize - low) * k;
            }
        }
        return d;
    }

    public boolean selectDcLocalNodes(MembershipState state) {
        int localMembers = state.dcMembers().size();
        double probability = localMembers > 4 ? this.crossDcGossipProbability : package$.MODULE$.max((double)(5 - localMembers) * 0.25, this.crossDcGossipProbability);
        return ThreadLocalRandom.current().nextDouble() > probability;
    }

    public boolean preferNodesWithDifferentView(MembershipState state) {
        return ThreadLocalRandom.current().nextDouble() < this.adjustedGossipDifferentViewProbability(state.latestGossip().members().size());
    }

    public List<String> dcsInRandomOrder(List<String> dcs) {
        return (List)Random$.MODULE$.shuffle(dcs, List$.MODULE$.canBuildFrom());
    }

    public Option<UniqueAddress> selectRandomNode(IndexedSeq<UniqueAddress> nodes) {
        return nodes.isEmpty() ? None$.MODULE$ : new Some(nodes.apply(ThreadLocalRandom.current().nextInt(nodes.size())));
    }

    private final Option selectOtherDcNode$1(List randomizedDcs, MembershipState state$1) {
        List list;
        block3: {
            Option option;
            while (true) {
                List tail;
                block6: {
                    None$ none$;
                    block5: {
                        block4: {
                            if (!Nil$.MODULE$.equals(list = randomizedDcs)) break block4;
                            none$ = None$.MODULE$;
                            break block5;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        String dc = (String)colon2.head();
                        tail = colon2.tl$1();
                        option = ((TraversableOnce)state$1.ageSortedTopOldestMembersPerDc().apply((Object)dc)).collectFirst((PartialFunction)new Serializable(this, state$1){
                            public static final long serialVersionUID = 0L;
                            private final MembershipState state$1;

                            public final <A1 extends Member, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                                A1 A1 = x7;
                                Object object = this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x7);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Member x7) {
                                Member member2 = x7;
                                boolean bl = this.state$1.validNodeForGossip(member2.uniqueAddress());
                                return bl;
                            }
                            {
                                this.state$1 = state$1;
                            }
                        });
                        if (!(option instanceof Some)) break block6;
                        Some some = (Some)option;
                        UniqueAddress addr = (UniqueAddress)some.x();
                        Some some2 = new Some((Object)addr);
                        none$ = some2;
                    }
                    return none$;
                }
                if (!None$.MODULE$.equals(option)) break;
                randomizedDcs = tail;
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)list);
    }

    private final Vector findFirstDcWithValidNodes$1(List left, MembershipState state$2, Map nodesPerDc$1) {
        List list;
        block6: {
            Vector vector;
            block5: {
                while ((list = left) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String dc = (String)colon2.head();
                    List tail = colon2.tl$1();
                    SortedSet validNodes = (SortedSet)((TraversableLike)nodesPerDc$1.apply((Object)dc)).collect((PartialFunction)new Serializable(this, state$2){
                        public static final long serialVersionUID = 0L;
                        private final MembershipState state$2;

                        public final <A1 extends Member, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                            A1 A1 = x11;
                            Object object = this.state$2.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x11);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Member x11) {
                            Member member2 = x11;
                            boolean bl = this.state$2.validNodeForGossip(member2.uniqueAddress());
                            return bl;
                        }
                        {
                            this.state$2 = state$2;
                        }
                    }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                    if (validNodes.nonEmpty()) {
                        vector = validNodes.toVector();
                        break block5;
                    }
                    left = tail;
                }
                if (!Nil$.MODULE$.equals(list)) break block6;
                vector = scala.package$.MODULE$.Vector().empty();
            }
            return vector;
        }
        throw new MatchError((Object)list);
    }

    public GossipTargetSelector(double reduceGossipDifferentViewProbability, double crossDcGossipProbability) {
        this.reduceGossipDifferentViewProbability = reduceGossipDifferentViewProbability;
        this.crossDcGossipProbability = crossDcGossipProbability;
    }
}

