/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.routing;

import akka.actor.ActorInitializationException$;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Address;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Up$;
import akka.cluster.MemberStatus$WeaklyUp$;
import akka.cluster.routing.ClusterRouterActor;
import akka.cluster.routing.ClusterRouterActor$;
import akka.routing.ActorRefRoutee;
import akka.routing.ActorSelectionRoutee;
import akka.routing.Group;
import akka.routing.Pool;
import akka.routing.Routee;
import akka.routing.RouterActor;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class ClusterRouterActor$class {
    public static Cluster cluster(RouterActor $this) {
        return (Cluster)Cluster$.MODULE$.apply($this.context().system());
    }

    public static void preStart(RouterActor $this) {
        ((ClusterRouterActor)$this).cluster().subscribe($this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public static void postStop(RouterActor $this) {
        ((ClusterRouterActor)$this).cluster().unsubscribe($this.self());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAvailable(RouterActor $this, Member m) {
        MemberStatus memberStatus = m.status();
        MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
        if (memberStatus == null ? memberStatus$Up$ != null : !memberStatus.equals(memberStatus$Up$)) {
            MemberStatus memberStatus2 = m.status();
            MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
            if (memberStatus2 == null) {
                if (memberStatus$WeaklyUp$ != null) {
                    return false;
                }
            } else if (!memberStatus2.equals(memberStatus$WeaklyUp$)) return false;
        }
        if (!ClusterRouterActor$class.satisfiesRoles((RouterActor)((ClusterRouterActor)$this), m.roles())) return false;
        if (((ClusterRouterActor)$this).settings().allowLocalRoutees()) return true;
        Address address = m.address();
        Address address2 = ((ClusterRouterActor)$this).cluster().selfAddress();
        if (address == null) {
            if (address2 == null) return false;
            return true;
        } else if (address.equals(address2)) return false;
        return true;
    }

    private static boolean satisfiesRoles(RouterActor $this, Set memberRoles) {
        return ((ClusterRouterActor)$this).settings().useRoles().subsetOf((GenSet)memberRoles);
    }

    public static SortedSet availableNodes(RouterActor $this) {
        return ((ClusterRouterActor)$this).nodes().isEmpty() && ((ClusterRouterActor)$this).settings().allowLocalRoutees() && ClusterRouterActor$class.satisfiesRoles((RouterActor)((ClusterRouterActor)$this), ((ClusterRouterActor)$this).cluster().selfRoles()) ? (SortedSet)SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Address[]{((ClusterRouterActor)$this).cluster().selfAddress()}), Member$.MODULE$.addressOrdering()) : ((ClusterRouterActor)$this).nodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Address fullAddress(RouterActor $this, Routee routee) {
        Address address;
        Address address2;
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRefRoutee actorRefRoutee = (ActorRefRoutee)routee2;
            ActorRef ref = actorRefRoutee.ref();
            address2 = ref.path().address();
        } else {
            if (!(routee2 instanceof ActorSelectionRoutee)) throw new MatchError((Object)routee2);
            ActorSelectionRoutee actorSelectionRoutee = (ActorSelectionRoutee)routee2;
            ActorSelection sel = actorSelectionRoutee.selection();
            address2 = sel.anchor().path().address();
        }
        Address address3 = address = address2;
        if (address3 == null) return address3;
        Option option = address3.host();
        Option option2 = address3.port();
        if (!None$.MODULE$.equals(option)) return address3;
        if (!None$.MODULE$.equals(option2)) return address3;
        return ((ClusterRouterActor)$this).cluster().selfAddress();
    }

    public static void addMember(RouterActor $this, Member member2) {
        ((ClusterRouterActor)$this).nodes_$eq((SortedSet<Address>)((SortedSet)((ClusterRouterActor)$this).nodes().$plus((Object)member2.address())));
        ((ClusterRouterActor)$this).addRoutees();
    }

    public static void removeMember(RouterActor $this, Member member2) {
        Address address = member2.address();
        ((ClusterRouterActor)$this).nodes_$eq((SortedSet<Address>)((SortedSet)((ClusterRouterActor)$this).nodes().$minus((Object)address)));
        IndexedSeq affectedRoutees = (IndexedSeq)$this.cell().router().routees().filter((Function1)new Serializable($this, address){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RouterActor $outer;
            private final Address address$2;

            public final boolean apply(Routee x$5) {
                Address address = ((ClusterRouterActor)this.$outer).fullAddress(x$5);
                Address address2 = this.address$2;
                return !(address != null ? !address.equals(address2) : address2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.address$2 = address$2;
            }
        });
        $this.cell().removeRoutees((Iterable)affectedRoutees, true);
        ((ClusterRouterActor)$this).addRoutees();
    }

    public static PartialFunction clusterReceive(RouterActor $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RouterActor $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                void var7_13;
                boolean bl = false;
                ClusterEvent.MemberEvent memberEvent = null;
                A1 A1 = x3;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    ((ClusterRouterActor)this.$outer).nodes_$eq((SortedSet<Address>)((SortedSet)currentClusterState.members().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ClusterRouterActor$.anonfun.clusterReceive.1 $outer;

                        public final <A1 extends Member, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                            A1 A1 = x4;
                            Object object = ((ClusterRouterActor)this.$outer.akka$cluster$routing$ClusterRouterActor$$anonfun$$$outer()).isAvailable(A1) ? A1.address() : function1.apply(x4);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Member x4) {
                            Member member2 = x4;
                            boolean bl = ((ClusterRouterActor)this.$outer.akka$cluster$routing$ClusterRouterActor$$anonfun$$$outer()).isAvailable(member2);
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, SortedSet$.MODULE$.newCanBuildFrom(Member$.MODULE$.addressOrdering()))));
                    ((ClusterRouterActor)this.$outer).addRoutees();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return var7_13;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    bl = true;
                    memberEvent = (ClusterEvent.MemberEvent)A1;
                    if (((ClusterRouterActor)this.$outer).isAvailable(memberEvent.member())) {
                        ((ClusterRouterActor)this.$outer).addMember(memberEvent.member());
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        return var7_13;
                    }
                }
                if (bl) {
                    ((ClusterRouterActor)this.$outer).removeMember(memberEvent.member());
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    return var7_13;
                }
                if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    ((ClusterRouterActor)this.$outer).removeMember(m);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    return var7_13;
                }
                if (!(A1 instanceof ClusterEvent.ReachableMember)) {
                    Object object = function1.apply(x3);
                    return var7_13;
                }
                ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                Member m = reachableMember.member();
                if (((ClusterRouterActor)this.$outer).isAvailable(m)) {
                    ((ClusterRouterActor)this.$outer).addMember(m);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit;
                return var7_13;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x3) {
                boolean bl = false;
                ClusterEvent.MemberEvent memberEvent = null;
                Object object = x3;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    bl = true;
                    memberEvent = (ClusterEvent.MemberEvent)object;
                    if (((ClusterRouterActor)this.$outer).isAvailable(memberEvent.member())) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    return true;
                }
                if (!(object instanceof ClusterEvent.ReachableMember)) return false;
                return true;
            }

            public /* synthetic */ RouterActor akka$cluster$routing$ClusterRouterActor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static void $init$(RouterActor $this) {
        if ($this.cell().routerConfig() instanceof Pool || $this.cell().routerConfig() instanceof Group) {
            ((ClusterRouterActor)$this).nodes_$eq((SortedSet<Address>)((SortedSet)((ClusterRouterActor)$this).cluster().readView().members().collect((PartialFunction)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RouterActor $outer;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = ((ClusterRouterActor)this.$outer).isAvailable(A1) ? A1.address() : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x2) {
                    Member member2 = x2;
                    boolean bl = ((ClusterRouterActor)this.$outer).isAvailable(member2);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, SortedSet$.MODULE$.newCanBuildFrom(Member$.MODULE$.addressOrdering()))));
            return;
        }
        throw ActorInitializationException$.MODULE$.apply(new StringBuilder().append((Object)"Cluster router actor can only be used with Pool or Group, not with ").append($this.cell().routerConfig().getClass()).toString());
    }
}

