/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.server.database;

import com.neo4j.causalclustering.core.CommercialCoreGraphDatabase;
import com.neo4j.causalclustering.discovery.CommercialDiscoveryServiceFactorySelector;
import com.neo4j.causalclustering.discovery.SslDiscoveryServiceFactory;
import com.neo4j.causalclustering.readreplica.CommercialReadReplicaGraphDatabase;
import com.neo4j.commercial.edition.CommercialGraphDatabase;
import java.io.File;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.database.EnterpriseGraphFactory;

public class CommercialGraphFactory
extends EnterpriseGraphFactory {
    public GraphDatabaseFacade newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        EnterpriseEditionSettings.Mode mode = (EnterpriseEditionSettings.Mode)config.get(EnterpriseEditionSettings.mode);
        File storeDir = (File)config.get(GraphDatabaseSettings.databases_root_path);
        SslDiscoveryServiceFactory discoveryServiceFactory = (SslDiscoveryServiceFactory)new CommercialDiscoveryServiceFactorySelector().select(config);
        switch (mode) {
            case CORE: {
                return new CommercialCoreGraphDatabase(storeDir, config, dependencies, discoveryServiceFactory);
            }
            case READ_REPLICA: {
                return new CommercialReadReplicaGraphDatabase(storeDir, config, dependencies, discoveryServiceFactory);
            }
            case SINGLE: {
                return new CommercialGraphDatabase(storeDir, config, dependencies);
            }
        }
        return super.newGraphDatabase(config, dependencies);
    }
}

