/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.time.Duration;
import java.util.UUID;
import org.neo4j.causalclustering.SessionTracker;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.ProgressTrackerImpl;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;

public class ReplicationModule {
    public static final String SESSION_TRACKER_NAME = "session-tracker";
    private final RaftReplicator replicator;
    private final ProgressTrackerImpl progressTracker;
    private final SessionTracker sessionTracker;

    public ReplicationModule(RaftMachine raftMachine, MemberId myself, PlatformModule platformModule, Config config, Outbound<MemberId, RaftMessages.RaftMessage> outbound, File clusterStateDirectory, FileSystemAbstraction fileSystem, LogProvider logProvider, AvailabilityGuard globalAvailabilityGuard, LocalDatabase localDatabase) {
        LifeSupport life = platformModule.life;
        DurableStateStorage sessionTrackerStorage = (DurableStateStorage)life.add(new DurableStateStorage<GlobalSessionTrackerState>(fileSystem, clusterStateDirectory, SESSION_TRACKER_NAME, new GlobalSessionTrackerState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.global_session_tracker_state_size), logProvider));
        this.sessionTracker = new SessionTracker(sessionTrackerStorage);
        GlobalSession myGlobalSession = new GlobalSession(UUID.randomUUID(), myself);
        LocalSessionPool sessionPool = new LocalSessionPool(myGlobalSession);
        this.progressTracker = new ProgressTrackerImpl(myGlobalSession);
        Duration initialBackoff = (Duration)config.get(CausalClusteringSettings.replication_retry_timeout_base);
        Duration upperBoundBackoff = (Duration)config.get(CausalClusteringSettings.replication_retry_timeout_limit);
        ExponentialBackoffStrategy progressRetryStrategy = new ExponentialBackoffStrategy(initialBackoff, upperBoundBackoff);
        long availabilityTimeoutMillis = ((Duration)config.get(CausalClusteringSettings.replication_retry_timeout_base)).toMillis();
        this.replicator = new RaftReplicator(raftMachine, myself, outbound, sessionPool, this.progressTracker, progressRetryStrategy, availabilityTimeoutMillis, globalAvailabilityGuard, logProvider, localDatabase, platformModule.monitors);
    }

    public RaftReplicator getReplicator() {
        return this.replicator;
    }

    public ProgressTrackerImpl getProgressTracker() {
        return this.progressTracker;
    }

    public SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }
}

