/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.UpstreamStrategyAddressSupplier;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.helpers.AdvertisedSocketAddress;

public interface CatchupAddressProvider {
    public AdvertisedSocketAddress primary() throws CatchupAddressResolutionException;

    public AdvertisedSocketAddress secondary() throws CatchupAddressResolutionException;

    public static CatchupAddressProvider fromSingleAddress(AdvertisedSocketAddress advertisedSocketAddress) {
        return new SingleAddressProvider(advertisedSocketAddress);
    }

    public static class PrioritisingUpstreamStrategyBasedAddressProvider
    implements CatchupAddressProvider {
        private final LeaderLocator leaderLocator;
        private final TopologyService topologyService;
        private UpstreamStrategyAddressSupplier secondaryUpstreamStrategyAddressSupplier;

        public PrioritisingUpstreamStrategyBasedAddressProvider(LeaderLocator leaderLocator, TopologyService topologyService, UpstreamDatabaseStrategySelector strategySelector) {
            this.leaderLocator = leaderLocator;
            this.topologyService = topologyService;
            this.secondaryUpstreamStrategyAddressSupplier = new UpstreamStrategyAddressSupplier(strategySelector, topologyService);
        }

        @Override
        public AdvertisedSocketAddress primary() throws CatchupAddressResolutionException {
            try {
                MemberId leadMember = this.leaderLocator.getLeader();
                return this.topologyService.findCatchupAddress(leadMember).orElseThrow(() -> new CatchupAddressResolutionException(leadMember));
            }
            catch (NoLeaderFoundException e) {
                throw new CatchupAddressResolutionException(e);
            }
        }

        @Override
        public AdvertisedSocketAddress secondary() throws CatchupAddressResolutionException {
            return this.secondaryUpstreamStrategyAddressSupplier.get();
        }
    }

    public static class SingleAddressProvider
    implements CatchupAddressProvider {
        private final AdvertisedSocketAddress socketAddress;

        public SingleAddressProvider(AdvertisedSocketAddress socketAddress) {
            this.socketAddress = socketAddress;
        }

        @Override
        public AdvertisedSocketAddress primary() {
            return this.socketAddress;
        }

        @Override
        public AdvertisedSocketAddress secondary() {
            return this.socketAddress;
        }
    }
}

