/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.CatchupServerHandler;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.RequestDecoderDispatcher;
import org.neo4j.causalclustering.catchup.RequestMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.ResponseMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.ServerMessageTypeHandler;
import org.neo4j.causalclustering.catchup.SimpleRequestDecoder;
import org.neo4j.causalclustering.catchup.storecopy.FileChunkEncoder;
import org.neo4j.causalclustering.catchup.storecopy.FileHeaderEncoder;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponseEncoder;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequestDecoder;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponseEncoder;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestDecoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseEncoder;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponseEncoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotEncoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequest;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CatchupProtocolServerInstaller
implements ProtocolInstaller<ProtocolInstaller.Orientation.Server> {
    private static final Protocol.ApplicationProtocols APPLICATION_PROTOCOL = Protocol.ApplicationProtocols.CATCHUP_1;
    private final NettyPipelineBuilderFactory pipelineBuilderFactory;
    private final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> modifiers;
    private final Log log;
    private final LogProvider logProvider;
    private final CatchupServerHandler catchupServerHandler;

    private CatchupProtocolServerInstaller(NettyPipelineBuilderFactory pipelineBuilderFactory, List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> modifiers, LogProvider logProvider, CatchupServerHandler catchupServerHandler) {
        this.pipelineBuilderFactory = pipelineBuilderFactory;
        this.modifiers = modifiers;
        this.log = logProvider.getLog(this.getClass());
        this.logProvider = logProvider;
        this.catchupServerHandler = catchupServerHandler;
    }

    @Override
    public void install(Channel channel) throws Exception {
        CatchupServerProtocol state = new CatchupServerProtocol();
        ((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)this.pipelineBuilderFactory.server(channel, this.log).modify(this.modifiers)).addFraming().add("enc_req_type", new ChannelHandler[]{new RequestMessageTypeEncoder()})).add("enc_res_type", new ChannelHandler[]{new ResponseMessageTypeEncoder()})).add("enc_res_tx_pull", new ChannelHandler[]{new TxPullResponseEncoder()})).add("enc_res_store_id", new ChannelHandler[]{new GetStoreIdResponseEncoder()})).add("enc_res_copy_fin", new ChannelHandler[]{new StoreCopyFinishedResponseEncoder()})).add("enc_res_tx_fin", new ChannelHandler[]{new TxStreamFinishedResponseEncoder()})).add("enc_res_pre_copy", new ChannelHandler[]{new PrepareStoreCopyResponse.Encoder()})).add("enc_snapshot", new ChannelHandler[]{new CoreSnapshotEncoder()})).add("enc_file_chunk", new ChannelHandler[]{new FileChunkEncoder()})).add("enc_file_header", new ChannelHandler[]{new FileHeaderEncoder()})).add("in_req_type", this.serverMessageHandler(state))).add("dec_req_dispatch", new ChannelHandler[]{this.requestDecoders(state)})).add("out_chunked_write", new ChannelHandler[]{new ChunkedWriteHandler()})).add("hnd_req_tx", this.catchupServerHandler.txPullRequestHandler(state))).add("hnd_req_store_id", this.catchupServerHandler.getStoreIdRequestHandler(state))).add("hnd_req_store_listing", this.catchupServerHandler.storeListingRequestHandler(state))).add("hnd_req_store_file", this.catchupServerHandler.getStoreFileRequestHandler(state))).add("hnd_req_index_snapshot", this.catchupServerHandler.getIndexSnapshotRequestHandler(state))).add("hnd_req_snapshot", this.catchupServerHandler.snapshotHandler(state).map(Collections::singletonList).orElse(Collections.emptyList()))).install();
    }

    private ChannelHandler serverMessageHandler(CatchupServerProtocol state) {
        return new ServerMessageTypeHandler(state, this.logProvider);
    }

    private ChannelInboundHandler requestDecoders(CatchupServerProtocol protocol) {
        RequestDecoderDispatcher<CatchupServerProtocol.State> decoderDispatcher = new RequestDecoderDispatcher<CatchupServerProtocol.State>(protocol, this.logProvider);
        decoderDispatcher.register(CatchupServerProtocol.State.TX_PULL, (ChannelInboundHandler)new TxPullRequestDecoder());
        decoderDispatcher.register(CatchupServerProtocol.State.GET_STORE_ID, (ChannelInboundHandler)new SimpleRequestDecoder((org.neo4j.function.Factory<? extends Message>)((org.neo4j.function.Factory)GetStoreIdRequest::new)));
        decoderDispatcher.register(CatchupServerProtocol.State.GET_CORE_SNAPSHOT, (ChannelInboundHandler)new SimpleRequestDecoder((org.neo4j.function.Factory<? extends Message>)((org.neo4j.function.Factory)CoreSnapshotRequest::new)));
        decoderDispatcher.register(CatchupServerProtocol.State.PREPARE_STORE_COPY, (ChannelInboundHandler)new PrepareStoreCopyRequestDecoder());
        decoderDispatcher.register(CatchupServerProtocol.State.GET_STORE_FILE, (ChannelInboundHandler)new GetStoreFileRequest.Decoder());
        decoderDispatcher.register(CatchupServerProtocol.State.GET_INDEX_SNAPSHOT, (ChannelInboundHandler)new GetIndexFilesRequest.Decoder());
        return decoderDispatcher;
    }

    @Override
    public Protocol.ApplicationProtocol applicationProtocol() {
        return APPLICATION_PROTOCOL;
    }

    @Override
    public Collection<Collection<Protocol.ModifierProtocol>> modifiers() {
        return this.modifiers.stream().map(ModifierProtocolInstaller::protocols).collect(Collectors.toList());
    }

    public static class Factory
    extends ProtocolInstaller.Factory<ProtocolInstaller.Orientation.Server, CatchupProtocolServerInstaller> {
        public Factory(NettyPipelineBuilderFactory pipelineBuilderFactory, LogProvider logProvider, CatchupServerHandler catchupServerHandler) {
            super(APPLICATION_PROTOCOL, modifiers -> new CatchupProtocolServerInstaller(pipelineBuilderFactory, (List)modifiers, logProvider, catchupServerHandler));
        }
    }
}

