/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.BoundedNetworkWritableChannel;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.string.UTF8;

public class PrepareStoreCopyResponse {
    private final File[] files;
    private final LongSet indexIds;
    private final Long transactionId;
    private final Status status;

    public static PrepareStoreCopyResponse error(Status errorStatus) {
        if (errorStatus == Status.SUCCESS) {
            throw new IllegalStateException("Cannot create error result from state: " + (Object)((Object)errorStatus));
        }
        return new PrepareStoreCopyResponse(new File[0], (LongSet)LongSets.immutable.empty(), 0L, errorStatus);
    }

    public static PrepareStoreCopyResponse success(File[] storeFiles, LongSet indexIds, long lastTransactionId) {
        return new PrepareStoreCopyResponse(storeFiles, indexIds, lastTransactionId, Status.SUCCESS);
    }

    LongSet getIndexIds() {
        return this.indexIds;
    }

    private PrepareStoreCopyResponse(File[] files, LongSet indexIds, Long transactionId, Status status) {
        this.files = files;
        this.indexIds = indexIds;
        this.transactionId = transactionId;
        this.status = status;
    }

    public File[] getFiles() {
        return this.files;
    }

    long lastTransactionId() {
        return this.transactionId;
    }

    public Status status() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepareStoreCopyResponse that = (PrepareStoreCopyResponse)o;
        return Arrays.equals(this.files, that.files) && this.indexIds.equals((Object)that.indexIds) && Objects.equals(this.transactionId, that.transactionId) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.files), this.indexIds, this.transactionId, this.status});
    }

    public static class Decoder
    extends ByteToMessageDecoder {
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            list.add(new StoreListingMarshal().unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(byteBuf)));
        }
    }

    public static class Encoder
    extends MessageToByteEncoder<PrepareStoreCopyResponse> {
        protected void encode(ChannelHandlerContext channelHandlerContext, PrepareStoreCopyResponse prepareStoreCopyResponse, ByteBuf byteBuf) throws Exception {
            new StoreListingMarshal().marshal(prepareStoreCopyResponse, (WritableChannel)new BoundedNetworkWritableChannel(byteBuf));
        }
    }

    public static class StoreListingMarshal
    extends SafeChannelMarshal<PrepareStoreCopyResponse> {
        @Override
        public void marshal(PrepareStoreCopyResponse prepareStoreCopyResponse, WritableChannel buffer) throws IOException {
            buffer.putInt(prepareStoreCopyResponse.status.ordinal());
            buffer.putLong(prepareStoreCopyResponse.transactionId.longValue());
            StoreListingMarshal.marshalFiles(buffer, prepareStoreCopyResponse.files);
            this.marshalIndexIds(buffer, prepareStoreCopyResponse.indexIds);
        }

        @Override
        protected PrepareStoreCopyResponse unmarshal0(ReadableChannel channel) throws IOException {
            int ordinal = channel.getInt();
            Status status = Status.values()[ordinal];
            Long transactionId = channel.getLong();
            File[] files = StoreListingMarshal.unmarshalFiles(channel);
            LongSet indexIds = this.unmarshalIndexIds(channel);
            return new PrepareStoreCopyResponse(files, indexIds, transactionId, status);
        }

        private static void marshalFiles(WritableChannel buffer, File[] files) throws IOException {
            buffer.putInt(files.length);
            for (File file : files) {
                StoreListingMarshal.putBytes(buffer, file.getName());
            }
        }

        private void marshalIndexIds(WritableChannel buffer, LongSet indexIds) throws IOException {
            buffer.putInt(indexIds.size());
            LongIterator itr = indexIds.longIterator();
            while (itr.hasNext()) {
                long indexId = itr.next();
                buffer.putLong(indexId);
            }
        }

        private static File[] unmarshalFiles(ReadableChannel channel) throws IOException {
            int numberOfFiles = channel.getInt();
            File[] files = new File[numberOfFiles];
            for (int i = 0; i < numberOfFiles; ++i) {
                files[i] = StoreListingMarshal.unmarshalFile(channel);
            }
            return files;
        }

        private static File unmarshalFile(ReadableChannel channel) throws IOException {
            byte[] name = StoreListingMarshal.readBytes(channel);
            return new File(UTF8.decode((byte[])name));
        }

        private LongSet unmarshalIndexIds(ReadableChannel channel) throws IOException {
            int numberOfIndexIds = channel.getInt();
            LongHashSet indexIds = new LongHashSet(numberOfIndexIds);
            for (int i = 0; i < numberOfIndexIds; ++i) {
                indexIds.add(channel.getLong());
            }
            return indexIds;
        }

        private static void putBytes(WritableChannel buffer, String value) throws IOException {
            byte[] bytes = UTF8.encode((String)value);
            buffer.putInt(bytes.length);
            buffer.put(bytes, bytes.length);
        }

        private static byte[] readBytes(ReadableChannel channel) throws IOException {
            int bytesLength = channel.getInt();
            byte[] bytes = new byte[bytesLength];
            channel.get(bytes, bytesLength);
            return bytes;
        }
    }

    static enum Status {
        SUCCESS,
        E_STORE_ID_MISMATCH,
        E_LISTING_STORE;

    }
}

