/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.IOException;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.DatabaseShutdownException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.TemporaryStoreDirectory;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreCopyProcess {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final LocalDatabase localDatabase;
    private final CopiedStoreRecovery copiedStoreRecovery;
    private final Log log;
    private final RemoteStore remoteStore;

    public StoreCopyProcess(FileSystemAbstraction fs, PageCache pageCache, LocalDatabase localDatabase, CopiedStoreRecovery copiedStoreRecovery, RemoteStore remoteStore, LogProvider logProvider) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.localDatabase = localDatabase;
        this.copiedStoreRecovery = copiedStoreRecovery;
        this.remoteStore = remoteStore;
        this.log = logProvider.getLog(this.getClass());
    }

    public void replaceWithStoreFrom(CatchupAddressProvider addressProvider, StoreId expectedStoreId) throws IOException, StoreCopyFailedException, DatabaseShutdownException {
        try (TemporaryStoreDirectory tempStore = new TemporaryStoreDirectory(this.fs, this.pageCache, this.localDatabase.databaseLayout().databaseDirectory());){
            this.remoteStore.copy(addressProvider, expectedStoreId, tempStore.databaseLayout(), false);
            try {
                this.copiedStoreRecovery.recoverCopiedStore(tempStore.databaseLayout());
            }
            catch (Throwable e) {
                tempStore.keepStore();
                throw e;
            }
            this.localDatabase.replaceWith(tempStore.databaseLayout().databaseDirectory());
        }
        this.log.info("Replaced store successfully");
    }
}

