/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDisk;
import org.neo4j.causalclustering.catchup.tx.FileCopyMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.monitoring.Monitors;

public class StreamToDiskProvider
implements StoreFileStreamProvider {
    private final File storeDir;
    private final FileSystemAbstraction fs;
    private final FileCopyMonitor fileCopyMonitor;

    StreamToDiskProvider(File storeDir, FileSystemAbstraction fs, Monitors monitors) {
        this.storeDir = storeDir;
        this.fs = fs;
        this.fileCopyMonitor = (FileCopyMonitor)monitors.newMonitor(FileCopyMonitor.class, new String[0]);
    }

    @Override
    public StoreFileStream acquire(String destination, int requiredAlignment) throws IOException {
        File fileName = new File(this.storeDir, destination);
        this.fs.mkdirs(fileName.getParentFile());
        this.fileCopyMonitor.copyFile(fileName);
        return StreamToDisk.fromFile(this.fs, fileName);
    }
}

