/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.DatabaseShutdownException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.tx.BatchingTxApplier;
import org.neo4j.causalclustering.catchup.tx.PullRequestMonitor;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutFactory;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.state.snapshot.TopologyLookupException;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;

public class CatchupPollingProcess
extends LifecycleAdapter {
    private final LocalDatabase localDatabase;
    private final Log log;
    private final Suspendable enableDisableOnStoreCopy;
    private final StoreCopyProcess storeCopyProcess;
    private final Supplier<DatabaseHealth> databaseHealthSupplier;
    private final CatchUpClient catchUpClient;
    private final UpstreamDatabaseStrategySelector selectionStrategy;
    private final TimerService timerService;
    private final long txPullIntervalMillis;
    private final BatchingTxApplier applier;
    private final PullRequestMonitor pullRequestMonitor;
    private final TopologyService topologyService;
    private Timer timer;
    private volatile State state = State.TX_PULLING;
    private DatabaseHealth dbHealth;
    private CompletableFuture<Boolean> upToDateFuture;
    private volatile long latestTxIdOfUpStream;

    public CatchupPollingProcess(LogProvider logProvider, LocalDatabase localDatabase, Suspendable enableDisableOnSoreCopy, CatchUpClient catchUpClient, UpstreamDatabaseStrategySelector selectionStrategy, TimerService timerService, long txPullIntervalMillis, BatchingTxApplier applier, Monitors monitors, StoreCopyProcess storeCopyProcess, Supplier<DatabaseHealth> databaseHealthSupplier, TopologyService topologyService) {
        this.localDatabase = localDatabase;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.enableDisableOnStoreCopy = enableDisableOnSoreCopy;
        this.catchUpClient = catchUpClient;
        this.selectionStrategy = selectionStrategy;
        this.timerService = timerService;
        this.txPullIntervalMillis = txPullIntervalMillis;
        this.applier = applier;
        this.pullRequestMonitor = (PullRequestMonitor)monitors.newMonitor(PullRequestMonitor.class, new String[0]);
        this.storeCopyProcess = storeCopyProcess;
        this.databaseHealthSupplier = databaseHealthSupplier;
        this.topologyService = topologyService;
    }

    public synchronized void start() {
        this.state = State.TX_PULLING;
        this.timer = this.timerService.create(Timers.TX_PULLER_TIMER, Group.PULL_UPDATES, timeout -> this.onTimeout());
        this.timer.set(TimeoutFactory.fixedTimeout(this.txPullIntervalMillis, TimeUnit.MILLISECONDS));
        this.dbHealth = this.databaseHealthSupplier.get();
        this.upToDateFuture = new CompletableFuture();
    }

    public Future<Boolean> upToDateFuture() {
        return this.upToDateFuture;
    }

    public void stop() {
        this.state = State.CANCELLED;
        this.timer.cancel(Timer.CancelMode.SYNC_WAIT);
    }

    public State state() {
        return this.state;
    }

    private void onTimeout() {
        try {
            switch (this.state) {
                case TX_PULLING: {
                    this.pullTransactions();
                    break;
                }
                case STORE_COPYING: {
                    this.copyStore();
                    break;
                }
                default: {
                    throw new IllegalStateException("Tried to execute catchup but was in state " + (Object)((Object)this.state));
                }
            }
        }
        catch (Throwable e) {
            this.panic(e);
        }
        if (this.state != State.PANIC && this.state != State.CANCELLED) {
            this.timer.reset();
        }
    }

    private synchronized void panic(Throwable e) {
        this.log.error("Unexpected issue in catchup process. No more catchup requests will be scheduled.", e);
        this.dbHealth.panic(e);
        this.upToDateFuture.completeExceptionally(e);
        this.state = State.PANIC;
    }

    private void pullTransactions() {
        MemberId upstream;
        try {
            upstream = this.selectionStrategy.bestUpstreamDatabase();
        }
        catch (UpstreamDatabaseSelectionException e) {
            this.log.warn("Could not find upstream database from which to pull.", (Throwable)e);
            return;
        }
        StoreId localStoreId = this.localDatabase.storeId();
        boolean moreToPull = true;
        int batchCount = 1;
        while (moreToPull) {
            moreToPull = this.pullAndApplyBatchOfTransactions(upstream, localStoreId, batchCount);
            ++batchCount;
        }
    }

    private synchronized void handleTransaction(CommittedTransactionRepresentation tx) {
        if (this.state == State.PANIC) {
            return;
        }
        try {
            this.applier.queue(tx);
        }
        catch (Throwable e) {
            this.panic(e);
        }
    }

    private synchronized void streamComplete() {
        if (this.state == State.PANIC) {
            return;
        }
        try {
            this.applier.applyBatch();
        }
        catch (Throwable e) {
            this.panic(e);
        }
    }

    private boolean pullAndApplyBatchOfTransactions(MemberId upstream, StoreId localStoreId, int batchCount) {
        TxStreamFinishedResponse response;
        long lastQueuedTxId = this.applier.lastQueuedTxId();
        this.pullRequestMonitor.txPullRequest(lastQueuedTxId);
        TxPullRequest txPullRequest = new TxPullRequest(lastQueuedTxId, localStoreId);
        this.log.debug("Pull transactions from %s where tx id > %d [batch #%d]", new Object[]{upstream, lastQueuedTxId, batchCount});
        try {
            AdvertisedSocketAddress fromAddress = this.topologyService.findCatchupAddress(upstream).orElseThrow(() -> new TopologyLookupException(upstream));
            response = this.catchUpClient.makeBlockingRequest(fromAddress, txPullRequest, new CatchUpResponseAdaptor<TxStreamFinishedResponse>(){

                @Override
                public void onTxPullResponse(CompletableFuture<TxStreamFinishedResponse> signal, TxPullResponse response) {
                    CatchupPollingProcess.this.handleTransaction(response.tx());
                }

                @Override
                public void onTxStreamFinishedResponse(CompletableFuture<TxStreamFinishedResponse> signal, TxStreamFinishedResponse response) {
                    CatchupPollingProcess.this.streamComplete();
                    signal.complete(response);
                }
            });
        }
        catch (CatchUpClientException | TopologyLookupException e) {
            this.log.warn("Exception occurred while pulling transactions. Will retry shortly.", (Throwable)e);
            this.streamComplete();
            return false;
        }
        this.latestTxIdOfUpStream = response.latestTxId();
        switch (response.status()) {
            case SUCCESS_END_OF_STREAM: {
                this.log.debug("Successfully pulled transactions from tx id %d", new Object[]{lastQueuedTxId});
                this.upToDateFuture.complete(Boolean.TRUE);
                return false;
            }
            case E_TRANSACTION_PRUNED: {
                this.log.info("Tx pull unable to get transactions starting from %d since transactions have been pruned. Attempting a store copy.", new Object[]{lastQueuedTxId});
                this.state = State.STORE_COPYING;
                return false;
            }
        }
        this.log.info("Tx pull request unable to get transactions > %d " + lastQueuedTxId);
        return false;
    }

    private void copyStore() {
        StoreId localStoreId = this.localDatabase.storeId();
        this.downloadDatabase(localStoreId);
    }

    private void downloadDatabase(StoreId localStoreId) {
        try {
            this.localDatabase.stopForStoreCopy();
            this.enableDisableOnStoreCopy.disable();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        try {
            MemberId source = this.selectionStrategy.bestUpstreamDatabase();
            AdvertisedSocketAddress fromAddress = this.topologyService.findCatchupAddress(source).orElseThrow(() -> new TopologyLookupException(source));
            this.storeCopyProcess.replaceWithStoreFrom(new CatchupAddressProvider.SingleAddressProvider(fromAddress), localStoreId);
        }
        catch (IOException | StoreCopyFailedException | TopologyLookupException | UpstreamDatabaseSelectionException e) {
            this.log.warn("Error copying store. Will retry shortly.", (Throwable)e);
            return;
        }
        catch (DatabaseShutdownException e) {
            this.log.warn("Store copy aborted due to shutdown.", (Throwable)e);
            return;
        }
        try {
            this.localDatabase.start();
            this.enableDisableOnStoreCopy.enable();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.latestTxIdOfUpStream = 0L;
        this.state = State.TX_PULLING;
        this.applier.refreshFromNewStore();
    }

    public String describeState() {
        if (this.state == State.TX_PULLING && this.applier.lastQueuedTxId() > 0L && this.latestTxIdOfUpStream > 0L) {
            return String.format("%s (%d of %d)", State.TX_PULLING.name(), this.applier.lastQueuedTxId(), this.latestTxIdOfUpStream);
        }
        return this.state.name();
    }

    static enum State {
        TX_PULLING,
        STORE_COPYING,
        PANIC,
        CANCELLED;

    }

    static enum Timers implements TimerService.TimerName
    {
        TX_PULLER_TIMER;

    }
}

