/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseListener;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.WritableChannel;

public class TransactionLogCatchUpWriter
implements TxPullResponseListener,
AutoCloseable {
    private final Lifespan lifespan = new Lifespan(new Lifecycle[0]);
    private final PageCache pageCache;
    private final Log log;
    private final boolean asPartOfStoreCopy;
    private final TransactionLogWriter writer;
    private final LogFiles logFiles;
    private final DatabaseLayout databaseLayout;
    private final NeoStores stores;
    private final boolean rotateTransactionsManually;
    private long lastTxId = -1L;
    private long expectedTxId;

    TransactionLogCatchUpWriter(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, Config config, LogProvider logProvider, long fromTxId, boolean asPartOfStoreCopy, boolean keepTxLogsInStoreDir, boolean forceTransactionRotations) throws IOException {
        this.pageCache = pageCache;
        this.log = logProvider.getLog(this.getClass());
        this.asPartOfStoreCopy = asPartOfStoreCopy;
        this.rotateTransactionsManually = forceTransactionRotations;
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig((Config)Config.defaults(), (DatabaseLayout)databaseLayout, (FileSystemAbstraction)fs, (PageCache)pageCache, (LogProvider)logProvider);
        this.stores = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), pageCache, fs, recordFormats, logProvider, EmptyVersionContextSupplier.EMPTY, new OpenOption[0]).openNeoStores(new StoreType[]{StoreType.META_DATA});
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)this.stores.getMetaDataStore());
        LogFilesBuilder logFilesBuilder = LogFilesBuilder.builder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)fs).withDependencies(dependencies).withLastCommittedTransactionIdSupplier(() -> fromTxId - 1L).withConfig(this.customisedConfig(config, keepTxLogsInStoreDir, forceTransactionRotations)).withLogVersionRepository((LogVersionRepository)this.stores.getMetaDataStore());
        this.logFiles = logFilesBuilder.build();
        this.lifespan.add((Lifecycle)this.logFiles);
        this.writer = new TransactionLogWriter(new LogEntryWriter((WritableChannel)this.logFiles.getLogFile().getWriter()));
        this.databaseLayout = databaseLayout;
        this.expectedTxId = fromTxId;
    }

    private Config customisedConfig(Config original, boolean keepTxLogsInStoreDir, boolean forceTransactionRotations) {
        Config config = Config.builder().build();
        if (!keepTxLogsInStoreDir) {
            original.getRaw(GraphDatabaseSettings.logical_logs_location.name()).ifPresent(v -> config.augment(GraphDatabaseSettings.logical_logs_location, v));
        }
        if (forceTransactionRotations) {
            original.getRaw(GraphDatabaseSettings.logical_log_rotation_threshold.name()).ifPresent(v -> config.augment(GraphDatabaseSettings.logical_log_rotation_threshold, v));
        }
        return config;
    }

    @Override
    public synchronized void onTxReceived(TxPullResponse txPullResponse) {
        CommittedTransactionRepresentation tx = txPullResponse.tx();
        long receivedTxId = tx.getCommitEntry().getTxId();
        if (this.rotateTransactionsManually && this.logFiles.getLogFile().rotationNeeded()) {
            TransactionLogCatchUpWriter.rotateTransactionLogs(this.logFiles);
        }
        if (receivedTxId != this.expectedTxId) {
            throw new RuntimeException(String.format("Expected txId: %d but got: %d", this.expectedTxId, receivedTxId));
        }
        this.lastTxId = receivedTxId;
        ++this.expectedTxId;
        try {
            this.writer.append(tx.getTransactionRepresentation(), this.lastTxId);
        }
        catch (IOException e) {
            this.log.error("Failed when appending to transaction log", (Throwable)e);
        }
    }

    private static void rotateTransactionLogs(LogFiles logFiles) {
        try {
            logFiles.getLogFile().rotate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.asPartOfStoreCopy) {
            long logVersion = this.logFiles.getLowestLogVersion();
            LogPosition checkPointPosition = new LogPosition(logVersion, 16L);
            this.log.info("Writing checkpoint as part of store copy: " + checkPointPosition);
            this.writer.checkPoint(checkPointPosition);
            File neoStore = this.databaseLayout.metadataStore();
            MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, (long)checkPointPosition.getByteOffset());
        }
        this.lifespan.close();
        if (this.lastTxId != -1L) {
            File neoStoreFile = this.databaseLayout.metadataStore();
            MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)this.lastTxId);
        }
        this.stores.close();
    }
}

